/*!\file TriaSearchx
 */

#include "./TriaSearchx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../objects/objects.h"
#include "../modules.h"

using namespace bamg;
using namespace std;

void TriaSearchx(double** ptria,double* index,int nel, double* x, double* y, int nods,double* x0, double* y0,int numberofgrids){

	/*Output*/
	double* tria=NULL;

	/*allocate: */
	tria=(double*)xmalloc(numberofgrids*sizeof(double));

	/*Intermediary*/
	R2     r;
	I2     I;
	int    i,j,k;
	int    i0,i1,i2;
	double areacoord[3];
	double aa,bb;
	double data_value;
	Icoor2 dete[3];
	int verbose=0;

	// read background mesh 
	Mesh Th(index,x,y,nods,nel); 
	Th.CreateSingleVertexToTriangleConnectivity();

	for(i=0;i<numberofgrids;i++){

		//Get current point coordinates
		r.x=x0[i]; r.y=y0[i];
		
		I=Th.R2ToI2(r);

		//Find triangle holding r/I
		Triangle &tb=*Th.TriangleFindFromCoord(I,dete);

		// internal point 
		if (Th.GetId(tb)<nel)tria[i]=(double)Th.GetId(tb);
		//external point
		else tria[i]=NAN;
	}


	/*Assign output pointers:*/
	*ptria=tria;
}
