/*!\file:  adjointdiagnostic_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void adjointdiagnostic_core(FemModel* femmodel){
	
	/*parameters: */
	bool isstokes;
	bool control_analysis;
	bool conserve_loads   = true;
	int  verbose          = 0;
	int  solution_type;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&isstokes,IsStokesEnum);
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*set analysis type to compute velocity: */
	_printf_("%s\n","      computing velocities");
	if(isstokes)femmodel->SetCurrentConfiguration(DiagnosticStokesAnalysisEnum);
	else femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);
	solver_diagnostic_nonlinear(femmodel,conserve_loads); 

	/*Update inputs using adjoint solution, and same type of setup as diagnostic solution: */
	_printf_("%s\n","      computing adjoint");
	if(isstokes)femmodel->SetCurrentConfiguration(DiagnosticStokesAnalysisEnum,AdjointStokesAnalysisEnum);
	else femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	solver_adjoint_linear(femmodel);
	
	if(solution_type==AdjointSolutionEnum && !control_analysis){
		if(verbose)_printf_("saving results:\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointxEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointyEnum);
		if (isstokes){
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointzEnum);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointpEnum);
		}
	}
}
