function femmodel=gradient_core(femmodel,varargin),
%GRADIENT_CORE - Brief compute inverse method gradient direction
% 
%   Usage:
%       femmodel=gradient_core(femmodel,varargin);
% 
%   Examples:
%      femmodel=gradient_core(femmodel);
%      femmodel=gradient_core(femmodel,step,search_scalar);

if nargin==3,
	step=varargin{1};
	search_scalar=varargin{2};
elseif nargin==1
	step=0;
	search_scalar=0;;
else
	help gradient_core
	error('bad usage');
end

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	control_type=femmodel.parameters.ControlType;
	control_steady=femmodel.parameters.ControlSteady;

	displaystring(verbose,'\n%s',['      compute gradient...']);
	grad=Gradj(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

	displaystring(verbose,'\n%s',['      retrieve old gradient...']);
	old_gradient=GetVectorFromInputs(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,OldGradientEnum,VertexEnum);

	if control_steady;
		femmodel=diagnostic_core(femmodel);
	end

	if (step>0 && search_scalar==0),
		displaystring(verbose,'\n%s',['      orthogonalization...']);
		new_gradient=Orth(grad,old_gradient);
	else
		displaystring(verbose,'\n%s',['      normalizing direction...']);
		new_gradient=Orth(grad,[]);
	end
	displaystring(verbose,'\n%s',['      done...']);

	%point gradient and old_gradient to new_gradient:
	grad=new_gradient;
	old_gradient=new_gradient;

	%plug back into inputs:
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputUpdateFromVector(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,grad,GradientEnum,VertexEnum);
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputUpdateFromVector(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,old_gradient,OldGradientEnum,VertexEnum);
