function femmodel=adjointdiagnostic_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state
%
%   Usage:
%      femmodel=adjointdiagnostic_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	isstokes=femmodel.parameters.IsStokes;
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;
	conserve_loads=true;

	%set analysis type to compute velocity:
	displaystring('\n%s',['      computing velocities']);
	if(isstokes), femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum);
	else femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum); end
	femmodel=solver_diagnostic_nonlinear(femmodel,conserve_loads);

	displaystring('\n%s',['      computing adjoint']);
	if(isstokes), femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum,AdjointStokesAnalysisEnum);
	else femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum); end
	femmodel=solver_adjoint_linear(femmodel);

	if(solution_type==AdjointSolutionEnum & ~control_analysis)
		displaystring(verbose,'\n%s',['      saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointyEnum);
		if(isstokes),
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointzEnum);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointpEnum);
		end
	end
