function femmodel=adjointbalancedthickness_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state
%
%   Usage:
%      femmodel=adjointbalancedthickness_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%set analysis type to compute velocity:
	displaystring('\n%s',['      computing thickness']);
	femmodel=SetCurrentConfiguration(femmodel,BalancedthicknessAnalysisEnum);
	femmodel=solver_linear(femmodel);

	displaystring('\n%s',['      computing adjoint']);
	femmodel=SetCurrentConfiguration(femmodel,BalancedthicknessAnalysisEnum,AdjointBalancedthicknessAnalysisEnum);
	femmodel=solver_adjoint_linear(femmodel);

	if(solution_type==AdjointSolutionEnum & ~control_analysis)
		displaystring(verbose,'\n%s',['      saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointEnum);
	end
