/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{

	/*Datasets {{{1*/
	ConstraintsEnum,
	DatasetsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	SubAnalysisTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticSolutionEnum,
	DiagnosticAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	DiagnosticStokesAnalysisEnum,
	HorizAnalysisEnum,
	HutterAnalysisEnum,
	StokesAnalysisEnum,
	VertAnalysisEnum,
	//control
	AdjointSolutionEnum,
	AdjointHorizAnalysisEnum,
	AdjointStokesAnalysisEnum,
	AdjointBalancedthicknessAnalysisEnum,
	ControlAnalysisEnum,
	GradientAnalysisEnum,
	InverseAnalysisEnum,
	//thermal
	ThermalSolutionEnum,
	ThermalAnalysisEnum,
	//transient
	Transient2DSolutionEnum,
	Transient2DAnalysisEnum,
	Transient3DSolutionEnum,
	Transient3DAnalysisEnum,
	SteadyAnalysisEnum,
	TransientAnalysisEnum, // needed by nighly run (to be removed at some point?)
	//slope
	BedSlopeSolutionEnum,
	BedSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	BalancedthicknessSolutionEnum,
	BalancedthicknessAnalysisEnum,
	BalancedvelocitiesSolutionEnum,
	BalancedvelocitiesAnalysisEnum,
	PrognosticSolutionEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//parameters
	ParametersSolutionEnum,
	ParametersAnalysisEnum,
	//steadystate
	SteadystateSolutionEnum,
	SteadystateAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	NoneApproximationEnum,
	PattynApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	SegmentEnum,
	/*Elements: */
	ElementEnum,
	DofIndexingEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	TriaEnum,
	/*Grids: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	QuadIceFrontEnum,
	QuadRiftFrontEnum,
	RiftfrontEnum,
	SegmentIcefrontEnum,
	SegmentRiftfrontEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	TriaVertexInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleMatArrayParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	FileParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ElementResultEnum,
	ExternalResultEnum,
	/*Spc: */
	SpcEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AccumulationRateEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AdjointpEnum,
	ArtDiffEnum,
	BedEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	CmResponseEnum,
	CmResponsesEnum,
	CmMaxDmpSlopeEnum,
	CmMaxDmpValueEnum,
	CmMinDmpSlopeEnum,
	CmMinDmpValueEnum,
	CmNoiseDmpEnum,
	ConstantEnum,
	ControlTypeEnum,
	ConvergedEnum,
	DhDtEnum,
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	DragTypeEnum,
	DtEnum,
	ElementOnBedEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	EpsVelEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GeothermalFluxEnum,
	InternalEnum,
	KflagEnum,
	MassFluxEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceAverageVelMisfitEnum,
	MaxPenetrationEnum,
	MeanVelEnum,
	MeltingOffsetEnum,
	MeltingRateEnum,
	MisfitEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	NumberNodeToElementConnectivityEnum,
	PenaltyOffsetEnum,
	PflagEnum,
	PressureEnum,
	PressureOldEnum,
	QmuPressureEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyBbarEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	StabilizeConstraintsEnum,
	StokesReconditioningEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureOldEnum,
	ThicknessEnum,
	ThicknessObsEnum,
	TypeEnum,
	VelEnum,
	VelObsEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxOldEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyOldEnum,
	QmuVyEnum,
	VzAverageEnum,
	VzEnum,
	VzObsEnum,
	VzOldEnum,
	QmuVzEnum,
	WeightsEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	MiniEnum,
	/*}}}*/
	/*Results{{{1*/
	DoubleElementResultEnum,
	TriaVertexElementResultEnum,
	PentaVertexElementResultEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleVecExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchVerticesEnum,
	PatchNodesEnum,
	TimeEnum,
	OutputFrequencyEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	ResidualEnum,
	AbsoluteEnum,
	/*}}}*/
	/*Material{{{1*/
	RhoIceEnum,
	RhoWaterEnum,
	GravityEnum,
	ThermalConductivityEnum,
	MixedLayerCapacityEnum,
	ThermalExchangeVelocityEnum,
	/*}}}*/
	/*Parameters{{{1*/
	IntersectEnum,
	ColinearEnum,
	SeparateEnum,
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	AdjointEnum,
	GradientEnum,
	OldGradientEnum,
	ConnectivityEnum,
	ControlParameterEnum,
	ControlSteadyEnum,
	DakotaParameterEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	HeatCapacityEnum,
	IsHutterEnum,
	IsMacAyealPattynEnum,
	IsStokesEnum,
	LatentHeatEnum,
	LowmemEnum,
	MaxIterEnum,
	MaxNonlinearIterationsEnum,
	MeltingPointEnum,
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	NStepsEnum,
	NdtEnum,
	NumOutputEnum,
	NumRiftsEnum,
	NumberOfElementsEnum,
	NumberOfNodesEnum,
	NumberOfVerticesEnum,
	OptScalEnum,
	OutputFilePointerEnum,
	ParameterOutputEnum,
	PenaltyMeltingEnum,
	QmuAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxSegmentsEnum,
	QmuNPartEnum,
	QmuOutNameEnum,
	QmuPartEnum,
	ResponseDescriptorsEnum,
	SolverStringEnum,
	SparsityEnum,
	TolXEnum,
	VariableDescriptorsEnum,
	VerboseEnum,
	WaitOnLockEnum,
	YtsEnum
	/*}}}*/
};

/*Functions on enums: */
int   EnumIsElement(int en);
int   EnumIsLoad(int en);
int   EnumIsMaterial(int en);
char *EnumToString(int enum_type);
int   StringToEnum(char *string);
char *EnumToModelField(int  en);

#endif
