/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

/*Headers:*/
/*{{{1*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matice: public Material{

	private: 
		/*Id*/
		int	   mid;

		/*hooks: */
		Hook* helement;

	public:
		/*WARNING: input should not be public but it is an easy way to update B from T (using UpdateFromSolution) from Pentas*/
		Inputs*  inputs;

		/*Matice constructors, destructors: {{{1*/
		Matice();
		Matice(int mid,int i, IoModel* iomodel);
		~Matice();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Material virtual functions resolution: {{{1*/
		void   InputDuplicate(int original_enum,int new_enum);
		void   Configure(Elements* elements);
		/*}}}*/
		/*Matice Numerics: {{{1*/
		void   SetCurrentConfiguration(Elements* elementsin,Loads* loadsin,Nodes* nodesin,Vertices* verticesin,Materials* materialsin,Parameters* parametersin);
		void   GetViscosity2d(double* pviscosity, double* pepsilon);
		void   GetViscosity3d(double* pviscosity3d, double* pepsilon);
		void   GetViscosity3dStokes(double* pviscosity3d, double* epsilon);
		void   GetViscosityComplement(double* pviscosity_complement, double* pepsilon);
		double GetB();
		double GetBbar();
		double GetN();
		bool   IsInput(int name);
		/*}}}*/
};

#endif  /* _MATICE_H_ */
