md=squaremesh(model,1000000,1000000,5,5);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster='none';

%redo the parameter file for this special shelf. 
%constant thickness, constrained (vy=0) flow into an icefront, 
%from 0 m/yr at the grounding line.

%needed later
ymin=min(md.y);
ymax=max(md.y);
xmin=min(md.x);
xmax=max(md.x);

di=md.rho_ice/md.rho_water;

h=1000;
md.thickness=h*ones(md.numberofgrids,1);
md.bed=-md.rho_ice/md.rho_water*md.thickness;
md.surface=md.bed+md.thickness;

%Initial velocity and pressure
md.vx=zeros(md.numberofgrids,1);
md.vy=zeros(md.numberofgrids,1);
md.vz=zeros(md.numberofgrids,1);
md.pressure=zeros(md.numberofgrids,1);

%Materials
md.observed_temperature=(273-20)*ones(md.numberofgrids,1);
md.rheology_B=paterson(md.observed_temperature);
md.rheology_n=3*ones(md.numberofelements,1);
md.temperature=md.observed_temperature;

%Boundary conditions:
md.spcvelocity=zeros(md.numberofgrids,6);

%constrain flanks to 0 normal velocity
pos=find(md.x==xmin | md.x==xmax);
md.spcvelocity(pos,1)=1;
md.spcvelocity(pos,3)=0;

%constrain grounding line to 0 velocity
pos=find(md.y==ymin);
md.spcvelocity(pos,1:2)=1;
md.spcvelocity(pos,3:4)=0;

%icefront
gridonicefront=zeros(md.numberofgrids,1);
pos=find(md.y==ymax); gridonicefront(pos)=1;
pos=find(gridonicefront(md.segments(:,1)) | gridonicefront(md.segments(:,2))); pressureload=md.segments(pos,:);
pressureload=[pressureload WaterEnum*md.elementoniceshelf(pressureload(:,end))];
md.pressureload=pressureload;

%partitioning
md.npart=md.numberofgrids;
md=partitioner(md,'package','linear','npart',md.npart);
md.part=md.part-1;

%Dakota options
%variables
md.variables.rheology_B=normal_uncertain('RheologyBbar',1,.5);

%responses
md.responses.MaxVel=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%method
md.qmu_method     =dakota_method('nond_l');

%parameters
md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';
md.qmu_params.tabular_graphics_data=true;

%imperative! 
md.eps_rel=10^-10; %tighten for qmu analysese
md.qmu_analysis=1;

%solve
md=solve(md,'analysis_type',DiagnosticSolutionEnum,'overwrite','y');

%Fields and tolerances to track changes
md=tres(md,'dakota');
md.results.dakota.importancefactors=importancefactors(md,'RheologyBbar','MaxVel')';
field_names     ={'importancefactors'};
field_tolerances={1e-11};
field_values={...
         md.results.dakota.importancefactors,...
	};
