/*\file TriaSearch.c
 *\brief: TriaSearch module. See TriaSearchx for more details.
 */
#include "./TriaSearch.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	int i;

	/*input: */
	double* index=NULL;
	int     nel;
	int     dummy;

	double* x=NULL;
	int     nods;

	double* y=NULL;

	double  x0,y0;
	
	/* output: */
	double  tria;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&TriaSearchUsage);

	/*Input datasets: */
	FetchData(&index,&nel,&dummy,INDEXHANDLE);
	FetchData(&x,&nods,XHANDLE);
	FetchData(&y,&nods,YHANDLE);
	FetchData(&x0,X0HANDLE);
	FetchData(&y0,Y0HANDLE);

	/* Echo: {{{1*/
	//printf("(x0,y0)=(%g,%g)\n",x0,y0);
	/*}}}*/

	/* Run core computations: */
	TriaSearchx(&tria,index,nel,x,y,nods,x0,y0);

	/* c to matlab: */
	tria++;

	/*Write data: */
	WriteData(TRIA,tria);

	/*end module: */
	MODULEEND();
}

void TriaSearchUsage(void)
{
	_printf_("TriaSearch- find triangle holding a point (x0,y0) in a mesh\n");
	_printf_("\n");
	_printf_("   Usage:\n");
	_printf_("         tria=TriaSearch(index,x,y,x0,y0);\n");
	_printf_("      index,x,y: mesh triangulatrion\n");
	_printf_("      x0,y0: coordinates of the point for which we are trying to find a triangle\n");
	_printf_("\n");
}
