/*!\file TriaSearchx
 */

#include "./TriaSearchx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../objects/objects.h"
#include "../modules.h"

using namespace bamg;
using namespace std;

void TriaSearchx(double* ptria,double* index,int nel, double* x, double* y, int nods,double x0, double y0){

	/*Output*/
	double tria;

	/*Intermediary*/
	R2     r;
	I2     I;
	int    i,j,k;
	int    i0,i1,i2;
	double areacoord[3];
	double aa,bb;
	double data_value;
	Icoor2 dete[3];
	int verbose=0;

	// read background mesh 
	if (verbose) printf("Reading mesh\n");
	Mesh Th(index,x,y,nods,nel); 
	Th.CreateSingleVertexToTriangleConnectivity();

	//Get current point coordinates
	r.x=x0; r.y=y0;
	I=Th.R2ToI2(r);

	//Find triangle holding r/I
	Triangle &tb=*Th.TriangleFindFromCoord(I,dete);

	// internal point 
	if (tb.det>0){ 
		//Area coordinate
		areacoord[0]= (double) dete[0]/ tb.det;
		areacoord[1]= (double) dete[1] / tb.det;
		areacoord[2]= (double) dete[2] / tb.det;
		//3 vertices of the triangle
		i0=Th.GetId(tb[0]);
		i1=Th.GetId(tb[1]);
		i2=Th.GetId(tb[2]);
		//triangle number
		tria=(double)Th.GetId(tb);
	}
	//external point
	else tria=NAN;
	
	/*Assign output pointers:*/
	*ptria=tria;
}
