/*!\file:  isdistributed.cpp
 * \brief: figure out if a dakota variable descriptor indicates presence of a distributed 
 * variable. For example: "rho_ice" is not distributed, but "thickness1" is. 
 * If variable is distributed, return root of the variable name (here, if would be "thickness" 
 * for variable descriptor "thickness1").
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include <ctype.h>
#include "../Alloc/alloc.h"

int isdistributed(char** proot,char* name){

	int i;

	/*output: */
	int   distributed=0;
	char* root=NULL;

	/*Look at the end of the string, whether it's numeric or not: */
	if (isdigit(name[strlen(name)-1]))distributed=1;

	if(distributed){
		
		root=(char*)xmalloc((strlen(name)+1)*sizeof(char));
		strcpy(root,name);
	
		/*Start from the end, until we find a letter, which we will, otherwise error out: */
		for(i=strlen(name)-1;i>=0;i--){
			if (isdigit(name[i])){
				root[i]='\0'; //finish the string here and keep looking for a letter
			}
			else break;
		}
	}

	/*Assign output pointers:*/
	*proot=root;
	return distributed;
}

