/*!\file DakotaResponsesx
 * \brief: update datasets using  parameter inputs
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./DakotaResponsesx.h"
#include "../../Container/Container.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../toolkits/toolkits.h"
#include "../modules.h"


void DakotaResponsesx(double* responses,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters,char** responses_descriptors,int numresponses){

	int        i,j,k;
	int        dummy;
	int        counter;
	extern int my_rank;
	bool       process_units = true;

	/*intermediary: */
	char* response_descriptor=NULL;
	double femmodel_response;
			
	for(i=0;i<numresponses;i++){

		response_descriptor=responses_descriptors[i];

		/*Compute response for this response_descriptor:*/
		Responsex(&femmodel_response,elements,nodes, vertices,loads,materials, parameters,response_descriptor,process_units);

		#ifdef _DEBUG_
		if(my_rank==0)printf("response: %s: %g\n",response_descriptor,femmodel_response);
		#endif
			
		/*send response back to Dakota only on cpu 0: */
		if(my_rank==0)responses[i]=femmodel_response;
	}

	/*Synthesize echo: {{{*/
	if(my_rank==0){
		printf("   responses: %i: ",numresponses);
		for(i=0;i<numresponses-1;i++)printf("%g|",responses[i]);
		printf("%g",responses[numresponses-1]);
		printf("\n");
	}
	/*}}}*/

}
