/*!\file: balancedvelocities_core.cpp
 * \brief: core of the balancedvelocities solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void balancedvelocities_core(FemModel* femmodel){

	/*flags: */
	int  verbose          = 0;
	int  dim;
	bool control_analysis;
	int  solution_type;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(BalancedvelocitiesAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	_printf_("call computational core:\n");
	solver_linear(femmodel);

	if(solution_type==BalancedvelocitiesSolutionEnum && !control_analysis){
		if(verbose)_printf_("saving results:\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VelEnum);
	}

}
