function femmodel=prognostic_core(femmodel)
%PROGNOSTIC_CORE - linear solution sequence
%
%   Usage:
%      femmodel=prognostic_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,PrognosticAnalysisEnum);

	displaystring(verbose,'\n%s',['call computational core...']);
	femmodel=solver_linear(femmodel);
	
	if (solution_type==PrognosticSolutionEnum & ~control_analysis)
		displaystring(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum);
	end

end %end function
