/*!\file: Update.h: abstract class used by some objects to update their properties
 * \brief prototypes for Update.h
 */ 

#ifndef _UPDATE_H_
#define  _UPDATE_H_

/*Headers:*/
/*{{{1*/
#include "../shared/shared.h"
/*}}}*/

class Update{

	public:

		virtual void  InputUpdateFromVector(double* vector, int name, int type)=0;
		virtual void  InputUpdateFromVector(int* vector, int name, int type)=0;
		virtual void  InputUpdateFromVector(bool* vector, int name, int type)=0;
		virtual void  InputUpdateFromVectorDakota(double* vector, int name, int type)=0;
		virtual void  InputUpdateFromVectorDakota(int* vector, int name, int type)=0;
		virtual void  InputUpdateFromVectorDakota(bool* vector, int name, int type)=0;
		virtual void  InputUpdateFromConstant(double constant, int name)=0;
		virtual void  InputUpdateFromConstant(int constant, int name)=0;
		virtual void  InputUpdateFromConstant(bool constant, int name)=0;
		virtual void  InputUpdateFromSolution(double* solution)=0;

};

#endif //ifndef _UPDATE_H_

