/*!\file InputUpdateFromVectorx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromVectorx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vec vector, int NameEnum, int TypeEnum){

	double* serial_vector=NULL;

	VecToMPISerial(&serial_vector,vector);

	InputUpdateFromVectorx( elements,nodes, vertices, loads, materials, parameters,serial_vector,NameEnum, TypeEnum);

	/*Free ressources:*/
	xfree((void**)&serial_vector);
}

	
void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,double* vector, int NameEnum, int TypeEnum){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
}

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int* vector, int NameEnum, int TypeEnum){
	
	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
}

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,bool* vector, int NameEnum, int TypeEnum){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,NameEnum,TypeEnum);
	}
}
