/*!\file Responsex
 * \brief: compute response according to a response descriptor
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../Container/Container.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../toolkits/toolkits.h"
#include "../modules.h"

void Responsex(double* presponse,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters,const char* response_descriptor,bool process_units){

	if(strcmp(response_descriptor,"MinVel")==0){
		MinVelx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxVel")==0){
		MaxVelx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MinVx")==0){
		MinVxx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxVx")==0){
		MaxVxx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxAbsVx")==0){
		MaxAbsVxx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MinVy")==0){
		MinVyx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxVy")==0){
		MaxVyx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxAbsVy")==0){
		MaxAbsVyx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MinVz")==0){
		MinVzx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxVz")==0){
		MaxVzx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"MaxAbsVz")==0){
		MaxAbsVzx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strncmp(response_descriptor,"MassFlux",8)==0){
		MassFluxx(presponse,elements,nodes,vertices,loads,materials,parameters,response_descriptor,process_units);
	}
	else if(strcmp(response_descriptor,"SurfaceAbsVelMisfit")==0){
		SurfaceAbsVelMisfitx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"SurfaceRelVelMisfit")==0){
		SurfaceRelVelMisfitx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"SurfaceLogVelMisfit")==0){
		SurfaceLogVelMisfitx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"SurfaceLogVxVyMisfit")==0){
		SurfaceLogVxVyMisfitx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"SurfaceAverageVelMisfit")==0){
		SurfaceAverageVelMisfitx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else if(strcmp(response_descriptor,"ThicknessAbsMisfit")==0){
		ThicknessAbsMisfitx( presponse, elements,nodes, vertices, loads, materials, parameters,process_units);
	}
	else{
		ISSMERROR(" response descriptor \"%s\" not supported yet!",response_descriptor);
	}
}
