/*!\file SurfaceAbsVelMisfitx
 * \brief: compute misfit between observations and model
 */

#include "./SurfaceAbsVelMisfitx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SurfaceAbsVelMisfitx( double* pJ, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*output: */
	double J=0;
	double J_sum;

	/*Compute Misfit: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		J+=element->SurfaceAbsVelMisfit(process_units);
	}

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&J,&J_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&J_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD);
	J=J_sum;

	/*Assign output pointers: */
	*pJ=J;
}
