/*\file CostFunction.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./CostFunction.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Loads      *loads      = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	int         response;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CostFunctionUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&response,RESPONSE);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	CostFunctionx(&J, elements,nodes,vertices, loads,materials,parameters,response);

	/*write output : */
	WriteData(COST,J);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void CostFunctionUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [J] = %s(elements,nodes,vertices,loads, materials, parameters,response);\n",__FUNCT__);
	_printf_("\n");
}
