function femmodel=adjoint_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state
%
%   Usage:
%      femmodel=adjoint_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	isstokes=femmodel.parameters.IsStokes;
	dim=femmodel.parameters.Dim;
	solution_type=femmodel.parameters.SolutionType;
	conserve_loads=true;

	%set analysis type to compute velocity:
	if (solution_type==DiagnosticSolutionEnum | solution_type==SteadystateSolutionEnum)
		displaystring('\n%s',['      computing velocities']);
		if(isstokes), femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum);
		else femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum); end
		femmodel=solver_diagnostic_nonlinear(femmodel,conserve_loads);
	elseif (solution_type==BalancedthicknessSolutionEnum)
		femmodel=SetCurrentConfiguration(femmodel,BalancedthicknessAnalysisEnum);
		femmodel=solver_linear(femmodel);
	else
		error('solution not implemented yet');
	end

	displaystring('\n%s',['      computing adjoint']);
	if (solution_type==DiagnosticSolutionEnum | solution_type==SteadystateSolutionEnum)
		if(isstokes), femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum,AdjointStokesAnalysisEnum);
		else femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum); end
	elseif (solution_type==BalancedthicknessSolutionEnum),
		femmodel=SetCurrentConfiguration(femmodel,BalancedthicknessAnalysisEnum,AdjointBalancedthicknessAnalysisEnum);
	end
	femmodel=solver_adjoint_linear(femmodel);

	displaystring(verbose,'\n%s',['      saving results...']);
	if(solution_type==AdjointSolutionEnum)
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointyEnum);
		if(isstokes),
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointzEnum);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointpEnum);
		end
	end

