/*!\file:  adjoint_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void adjoint_core(FemModel* femmodel){
	
	/*parameters: */
	int  verbose        = 0;
	bool isstokes;
	bool conserve_loads = true;
	int  solution_type;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&isstokes,IsStokesEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*set analysis type to compute velocity: */
	if (solution_type==SteadystateSolutionEnum || solution_type==DiagnosticSolutionEnum){
		_printf_("%s\n","      computing velocities");
		if(isstokes)femmodel->SetCurrentConfiguration(DiagnosticStokesAnalysisEnum);
		else femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);
		solver_diagnostic_nonlinear(femmodel,conserve_loads); 
	}
	else if (solution_type==BalancedthicknessSolutionEnum){
		femmodel->SetCurrentConfiguration(BalancedthicknessAnalysisEnum);
		solver_linear(femmodel); 
	}
	else{
		ISSMERROR("Solution %s not implemented yet",EnumToString(solution_type));
	}

	/*Update inputs using adjoint solution, and same type of setup as diagnostic solution: */
	_printf_("%s\n","      computing adjoint");
	if (solution_type==SteadystateSolutionEnum || solution_type==DiagnosticSolutionEnum){
		if(isstokes)femmodel->SetCurrentConfiguration(DiagnosticStokesAnalysisEnum,AdjointStokesAnalysisEnum);
		else femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	}
	else if (solution_type==BalancedthicknessSolutionEnum){
		femmodel->SetCurrentConfiguration(BalancedthicknessAnalysisEnum,AdjointBalancedthicknessAnalysisEnum);
	}
	solver_adjoint_linear(femmodel);
	
	if(verbose)_printf_("saving results:\n");
	if(solution_type==AdjointSolutionEnum){
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointxEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointyEnum);
		if (isstokes){
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointzEnum);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointpEnum);
		}
	}
}
