/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type){
	
	int i;
	double* control_parameter=NULL;
	
	Parameters* parameters=NULL;

	/*Get parameters: */
	parameters=*pparameters;
	
	parameters->AddObject(new   BoolParam(ControlAnalysisEnum,iomodel->control_analysis));
	if(iomodel->control_analysis){

		/*What control type?*/
		if (strcmp(iomodel->control_type,"drag_coefficient")==0){
			parameters->AddObject(new IntParam(ControlTypeEnum,DragCoefficientEnum));
		}
		else  if (strcmp(iomodel->control_type,"rheology_B")==0){
			parameters->AddObject(new IntParam(ControlTypeEnum,RheologyB2dEnum));
		}
		else  if (strcmp(iomodel->control_type,"dhdt")==0){
			parameters->AddObject(new IntParam(ControlTypeEnum,DhDtEnum));
		}
		else{
			ISSMERROR("control_type %s not supported yet!",iomodel->control_type);
		}

		/*What solution type?*/
		if (solution_type==SteadystateSolutionEnum){
			parameters->AddObject(new BoolParam(ControlSteadyEnum,true));
		}
		else{
			parameters->AddObject(new BoolParam(ControlSteadyEnum,false));
		}
		parameters->AddObject(new IntParam(NStepsEnum,iomodel->nsteps));
		parameters->AddObject(new DoubleParam(TolXEnum,iomodel->tolx));
		parameters->AddObject(new DoubleParam(EpsCmEnum,iomodel->eps_cm));
		parameters->AddObject(new DoubleParam(MeanVelEnum,iomodel->meanvel));
		parameters->AddObject(new DoubleParam(CmNoiseDmpEnum,iomodel->cm_noisedmp));
		parameters->AddObject(new DoubleParam(CmMinDmpValueEnum,iomodel->cm_mindmp_value));
		parameters->AddObject(new DoubleParam(CmMinDmpSlopeEnum,iomodel->cm_mindmp_slope));
		parameters->AddObject(new DoubleParam(CmMaxDmpValueEnum,iomodel->cm_maxdmp_value));
		parameters->AddObject(new DoubleParam(CmMaxDmpSlopeEnum,iomodel->cm_maxdmp_slope));
		parameters->AddObject(new DoubleParam(CmMinEnum,iomodel->cm_min));
		parameters->AddObject(new DoubleParam(CmMaxEnum,iomodel->cm_max));
		parameters->AddObject(new BoolParam(CmGradientEnum,iomodel->cm_gradient));

		/*Now, recover fit, optscal and maxiter as vectors: */
		IoModelFetchData(&iomodel->fit,NULL,NULL,iomodel_handle,"fit");
		IoModelFetchData(&iomodel->cm_jump,NULL,NULL,iomodel_handle,"cm_jump");
		IoModelFetchData(&iomodel->optscal,NULL,NULL,iomodel_handle,"optscal");
		IoModelFetchData(&iomodel->maxiter,NULL,NULL,iomodel_handle,"maxiter");

		parameters->AddObject(new DoubleVecParam(FitEnum,iomodel->fit,iomodel->nsteps));
		parameters->AddObject(new DoubleVecParam(CmJumpEnum,iomodel->cm_jump,iomodel->nsteps));
		parameters->AddObject(new DoubleVecParam(OptScalEnum,iomodel->optscal,iomodel->nsteps));
		parameters->AddObject(new DoubleVecParam(MaxIterEnum,iomodel->maxiter,iomodel->nsteps));

		xfree((void**)&iomodel->fit);
		xfree((void**)&iomodel->cm_jump);
		xfree((void**)&iomodel->optscal);
		xfree((void**)&iomodel->maxiter);

		IoModelFetchData(&control_parameter,NULL,NULL,iomodel_handle,iomodel->control_type);
		parameters->AddObject(new DoubleVecParam(ControlParameterEnum,control_parameter,iomodel->nsteps));
		xfree((void**)&control_parameter);
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
