/*
 * solutions.h: 
 */

#ifndef SOLUTIONS_H_
#define SOLUTIONS_H_

#include "../objects/objects.h"
#include "../io/io.h"

struct OptArgs;
class FemModel;

/*cores: */
void adjoint_core(FemModel* femmodel);
void gradient_core(FemModel* femmodel,int step=0, double search_scalar=0);
void diagnostic_core(FemModel* femmodel);
void thermal_core(FemModel* femmodel);
void thermal_core_step(FemModel* femmodel,int step, double time);
void surfaceslope_core(FemModel* femmodel);
void bedslope_core(FemModel* femmodel);
void control_core(FemModel* femmodel);
void prognostic_core(FemModel* femmodel);
void balancedthickness_core(FemModel* femmodel);
void balancedvelocities_core(FemModel* femmodel);
void slopecompute_core(FemModel* femmodel);
void steadystate_core(FemModel* femmodel);
void transient2d_core(FemModel* femmodel);
void transient3d_core(FemModel* femmodel);
double objectivefunctionC(double search_scalar,OptArgs* optargs);

//convergence:
void convergence(int* pconverged, Mat K_ff,Vec p_f,Vec u_f,Vec u_f_old,Parameters* parameters);
bool controlconvergence(double* J, double* fit, double eps_cm, int n);
bool steadystateconvergence(FemModel* femmodel);

//optimization
int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);
int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);
int GradJSearch(double* search_vector,FemModel* femmodel,int step);

//diverse
void WriteLockFile(char* filename);
void stokescontrolinit(FemModel* femmodel);
void controlrestart(FemModel* femmodel,double* J);
void ResetBoundaryConditions(FemModel* femmodel, int analysis_type);

//solution configuration
void SolutionConfiguration(int** panalyses,int* pnumanalyses, void (**psolutioncore)(FemModel*),int solutiontype);
void CorePointerFromSolutionEnum(void (**psolutioncore)(FemModel*),int solutiontype);

#endif
