function [solutioncore]=CorePointerFromSolutionEnum(solutiontype),
%COREPOINTERFROMSOLUTIONENUM - returns solution_core function
%
%   Usage:
%      [solutioncore]=CorePointerFromSolutionEnum(solutiontype);

switch solutiontype,

	case DiagnosticSolutionEnum,         solutioncore='diagnostic_core';
	case SteadystateSolutionEnum,        solutioncore='steadystate_core';
	case ThermalSolutionEnum,            solutioncore='thermal_core';
	case PrognosticSolutionEnum,         solutioncore='prognostic_core';
	case BalancedthicknessSolutionEnum,  solutioncore='balancedthickness_core';
	case BalancedvelocitiesSolutionEnum, solutioncore='balancedvelocities_core';
	case SurfaceSlopeSolutionEnum,       solutioncore='surfaceslope_core';
	case BedSlopeSolutionEnum,           solutioncore='bedslope_core';
	case Transient2DSolutionEnum,        solutioncore='transient2d_core';
	case Transient3DSolutionEnum,        solutioncore='transient3d_core';
	otherwise error('%s%s%s',' solution type: ',EnumToString(solutiontype),' not supported yet!');

end
