function dvar=QmuSetupDesign(md,dvar,variables)

%get descriptor
descriptor=variables.descriptor;

%decide whether this is a distributed variable, which will drive whether we expand it into npart values,
%or if we just carry it forward as is. 

%if descriptor is something like 'Thickness1','Surface10', etc ... the variable expansion already did the work, skip
if qmuisdistributed(descriptor),
	dvar(end+1)=variables;
	return;
end

%if descriptor is more generic, like 'Thickness','RhoIce', decide whether it will get expanded.
flag=IsScaled(descriptor); %will error out if the descriptor is unknow.

if flag==0,
	dvar(end+1)=variables;

else if flag==1,

	if length(variables.stddev)>md.npart,
		error('QmuSetupDesign error message: stddev should be either a scalar or a ''npart'' length vector');
	end

	%ok, dealing with semi-discrete distributed variable. Distribute according to how many 
	%partitions we want

	for j=1:md.npart
		dvar(end+1)           =variables;
		dvar(end  ).descriptor=sprintf('%s%d',variables.descriptor,j);
		if length(variables.stddev)>1,
			dvar(end  ).stddev=variables.stddev(j);
		end
	end

else if flag==2,

	%special case
	if strcmpi(descriptor,'RiftsFriction'),
		dvar=setupriftsfriction(md,dvar,variable);
	end
end
