function partvector=AreaAverageOntoPartition(md,vector)
%AREAAVERAGEONTOPARTITION  compute partition values for a certain vector expressed on the vertices of the mesh. Use area weighted average.
%
%   Usage: average=AreaAverageOntoPartition(md,vector)
%

%ok, first check that part is Matlab matlab indexed
part=md.part+1;

%initialize output
partvector=zeros(max(part),1);

%start weight average
weightedvector=vector.*md.vwgt;
for i=1:max(part),
	pos=find(part==i);
	partvector(i)=sum(weightedvector(pos))/sum(md.vwgt(pos));
end
