/*\file EnumToModelField.cpp:
* \brief: output string associated with enum, that corresponds  to a model field
* for example: ThicknessEnum corresponds to model field thickness
*              DragCoefficientEnum corresponds to model field drag
*/

#include "../shared/shared.h"
#include "../include/include.h"
#include "./EnumDefinitions.h"

char* EnumToModelField(int en){

	switch(en){

		case ThicknessEnum : return "thickness";
		case DragCoefficientEnum : return "drag_coefficient";
		default : return ISSMERROR("No model field is associated to enum %s",EnumToString(en));
	}
}
