md=mesh(model,'../Exp/Square.exp',300000);
md=geography(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster=oshostname();

%partitioning
md.npart=md.numberofgrids;
md=partitioner(md,'package','linear','npart',md.npart);
md.part=md.part-1;
md.qmu_analysis=1;


%Dakota options
%variables
md.variables.rho_ice=normal_uncertain('RhoIce',md.rho_ice,0.01);
md.variables.drag_coefficient=normal_uncertain('DragCoefficient',1,0.01);

%responses
md.responses.MaxVel=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%method
md.qmu_method     =dakota_method('nond_l');

%parameters
md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';
md.qmu_params.tabular_graphics_data=true;

%imperative! 
md.eps_rel=10^-5; %tighten for qmu analysese

%solve
md=solve(md,'analysis_type',DiagnosticSolutionEnum,'overwrite','y');

%Fields and tolerances to track changes
md=tres(md,'dakota');
md.results.dakota.importancefactors=importancefactors(md,'DragCoefficient','MaxVel')';
field_names     ={'importancefactors'};
field_tolerances={1e-10};
field_values={...
         md.results.dakota.importancefactors,...
	};
