function stress_surface=StressSurfaceCompute(m,inputs,type);
%STRESSSURFACECOMPUTE - compute the stress at the upper boundary condition
%
%   return a vector of size (numberofelements,1), holding the stress for 
%   every element on surface
%
%   Usage:
%      stress_surface=StressSurfaceCompute(m,inputs,type)

%global variables
global cluster gridset

%recover fem model fields
elements=m.elements;
grids=m.grids;
materials=m.materials;
loads=m.loads;
gridset=m.gridset;
numberofelements=length(elements);

%initialization
stress_surface=zeros(numberofelements,1);

if strcmpi(type,'2d')
	disp('stress_surface not computed for 2d meshes')
	return
end

%initialize vectors
stress_surface=struct('xx',[],'yy',[],'zz',[],'xy',[],'xz',[],'yz',[],'stress_n','stress_nn','normal_x',[],'normal_y',[],'normal_z',[],'principalvalue1',[],'principalaxis1',[],'principalvalue2',[],'principalaxis2',[],'principalvalue3',[],'principalaxis3',[],'effectivevalue',[]);
stress_surface1=zeros(numberofelements,6);
normal1=zeros(numberofelements,3);
stress_n1=zeros(numberofelements,3);
stress_nn1=zeros(numberofelements,1);
A1=zeros(numberofelements,1); Vx1=zeros(numberofelements,1); Vy1=zeros(numberofelements,1); Vz1=zeros(numberofelements,1);
A2=zeros(numberofelements,1); Vx2=zeros(numberofelements,1); Vy2=zeros(numberofelements,1); Vz2=zeros(numberofelements,1);
A3=zeros(numberofelements,1); Vx3=zeros(numberofelements,1); Vy3=zeros(numberofelements,1); Vz3=zeros(numberofelements,1);

%Go through all elements and call the stress_surface routine, then compute eigen values and vector
for n=1:length(elements),
	if ~isempty(elements(n).element),
		[stress_vector,normal]=StressSurface(elements(n).element,grids,materials,inputs);

		if ~isnan(stress_vector)
			stress_matrix=[stress_vector(1) stress_vector(4) stress_vector(5)
				      stress_vector(4)  stress_vector(2)  stress_vector(6)
				      stress_vector(5)  stress_vector(6)  stress_vector(3)];
			stress_n=stress_matrix*normal;
			stress_nn=normal'*stress_matrix*normal;

			%eigen values and vectors
			[directions,value]=eig(stress_matrix);

			%Plug into global vectors
			stress_surface1(n,:)=stress_vector;
			stress_n1(n,:)=stress_n;
			stress_nn1(n)=stress_nn;
			normal1(n,:)=normal';
			A1(n,1)=value(1,1); A2(n,1)=value(2,2); A3(n,1)=value(3,3);
			Vx1(n,1)=directions(1,1); Vx2(n,1)=directions(1,2); Vx3(n,1)=directions(1,3);
			Vy1(n,1)=directions(2,1); Vy2(n,1)=directions(2,2); Vy3(n,1)=directions(2,3);
			Vz1(n,1)=directions(3,1); Vz2(n,1)=directions(3,2); Vz3(n,1)=directions(3,3);
		else
			stress_surface1(n,:)=NaN*ones(1,6);
			stress_n1(n,:)=NaN*ones(1,3);
			stress_nn1(n)=NaN;
			normal1(n,:)=NaN*ones(1,3);
			A1(n,1)=NaN; A2(n,1)=NaN; A3(n,1)=NaN;
			Vx1(n,1)=NaN; Vx2(n,1)=NaN; Vx3(n,1)=NaN;
			Vy1(n,1)=NaN; Vy2(n,1)=NaN; Vy3(n,1)=NaN;
			Vz1(n,1)=NaN; Vz2(n,1)=NaN; Vz3(n,1)=NaN;
		end
	end
end

%plug results into outputs
%NB: Matlab sorts the eigen value in increasing order, we want the reverse
%components
stress_surface.xx=stress_surface1(:,1);
stress_surface.yy=stress_surface1(:,2);
stress_surface.zz=stress_surface1(:,3);
stress_surface.xy=stress_surface1(:,4);
stress_surface.xz=stress_surface1(:,5);
stress_surface.yz=stress_surface1(:,6);
%principal axis
stress_surface.principalvalue3=A1;
stress_surface.principalaxis3=[Vx1 Vy1 Vz1];
stress_surface.principalvalue2=A2;
stress_surface.principalaxis2=[Vx2 Vy2 Vz2];
stress_surface.principalvalue1=A3;
stress_surface.principalaxis1=[Vx3 Vy3 Vz3];
%norm or effective value
stress_surface.effectivevalue=1/sqrt(2)*sqrt(stress_surface.xx.^2+stress_surface.yy.^2+stress_surface.zz.^2+2*stress_surface.xy.^2+2*stress_surface.xz.^2+2*stress_surface.yz.^2);
%force
stress_surface.normal_x=normal1(:,1);
stress_surface.normal_y=normal1(:,2);
stress_surface.normal_z=normal1(:,3);
stress_surface.stress_n=stress_n1;
stress_surface.stress_nn=stress_nn1;
