function pressure=PressureElemCompute(m,inputs,type);
%PRESSUREELEMCOMPUTE - compute the pressure over each element
%
%   return a vector of size (numberofelements,1), holding the pressure for 
%   every element
%
%   Usage:
%      pressure=PressureElemCompute(m,inputs,type)

%global variables
global cluster gridset

%recover fem model fields
elements=m.elements;
grids=m.grids;
materials=m.materials;
loads=m.loads;
gridset=m.gridset;

%initialization
pressure=zeros((n2-n1)+1,1);

%Check 3d
if strcmpi(type,'2d')
	disp('pressure not computed for 2d meshes')
	return
end	

%Go through elements and build pressure defined as P=-1/3*tr(stress)
for n=1:length(elements)
	stress_tensor=Stress(elements(n).element,grids,materials,inputs);	
	trace=stress_tensor(1)+stress_tensor(2)+stress_tensor(3);
	pressure(n)=-1/3*trace;
end
