function viscousheating=ViscousHeatingCompute(m,inputs,type);
%VISCOUSHEATINGCOMPUTE - compute viscous heating
%
%   return a vector of size (numberofelements,1), holding the viscous heating for 
%   every element
%
%   Usage:
%      viscousheating=ViscousHeatingCompute(m,inputs,type)

%global variables
global cluster gridset

%recover fem model fields
elements=m.elements;
grids=m.grids;
materials=m.materials;
loads=m.loads;
gridset=m.gridset;

%initialize vector
viscousheating=zeros(numberofelements,1);

%Go through all elements and call the vicous heating routine.
for n=1:length(elements),
		
	if ~isempty(elements(n).element),
		viscousheating(n)=ViscousHeating(elements(n).element,grids,materials,inputs);
	end

end
