%EISMINT benchmark experiment A
numlayers=10;
resolution=30000;

%To begin with the numerical model
md=model;
md=roundmesh(md,750000,resolution);
md=geography(md,'',''); %We can not test iceshelves nor ice rises with this analytical solution
md=parameterize(md,'../Par/RoundSheetEISMINT.par');

%We extrude the model to have a 3d model
md=extrude(md,numlayers,1);
md=setelementstype(md,'hutter','all');

%Spc the grids on the bed
pos=find(md.gridonbed);
md.spcvelocity(pos,1:3)=1;

%Adapt the time steps to the resolution
md.dt=25;
md.output_frequency=20;

%Now we can solve the problem 
md=solve(md,'analysis_type',Transient3DSolutionEnum);
