function dvar=QmuSetupDesign(dvar,variables,params,varargin)

%recover model
for i=1:length(varargin)
    if strcmp(class(varargin{i}),'model')
        md=varargin{i};
        break;
    end
end


%get descriptor
descriptor=variables.descriptor;

%decide whether this is a distributed variable, which will drive whether we expand it into npart values,
%or if we just carry it forward as is. 

switch descriptor,
case {'RhoIce','RhoWater','HeatCapacity','ThermalConductivity','Gravity'},

	dvar(end+1)=variables;

case {'Thickness','Surface','Bed','DragCoefficient'},

	if length(variables.stddev)>md.npart,
		error('QmuSetupDesign error message: stddev should be either a scalar or a ''npart'' length vector');
	end

	%ok, dealing with semi-discrete distributed variable. Distribute according to how many 
	%partitions we want

	for j=1:md.npart
		dvar(end+1)           =variables;
		dvar(end  ).descriptor=sprintf('%s%d',variables.descriptor,j);
		if length(variables.stddev)>1,
			dvar(end  ).stddev=variables.stddev(j);
		end
	end

case {'RiftsFriction'},
	
	dvar=setupriftsfriction(dvar,variables,params,varargin{:});

otherwise
	error(['QmuSetupDesign warning message: could not find ' descriptor ' setup design function']);
end
