function femmodel=transient3d_core(femmodel)
%TRANSIENT3D_CORE - core of transient 2d solution
%
%   Usage:
%      femmodel=transient3d_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	ndt=femmodel.parameters.Ndt;
	dt=femmodel.parameters.Dt;
	yts=femmodel.parameters.Yts;
	solution_type=femmodel.parameters.SolutionType;
	output_frequency=femmodel.parameters.OutputFrequency;

	%Initialize
	time=0;
	step=0;

	%Loop through time
	while (time < ndt - (yts*eps)),

		%Increment
		step=step+1;
		time=time+dt;

		displaystring(verbose,'\n%s%g%s%i%s%g\n','time [yr] ',time,' iteration number: ',step,'/',floor(ndt/dt));

		displaystring(verbose,'\n%s',['computing temperature...']);
		femmodel=thermal_core_step(femmodel); 

		displaystring(verbose,'\n%s',['computing new velocities...']);
		femmodel=diagnostic_core(femmodel); 

		displaystring(verbose,'\n%s',['computing new thickness...']);
		femmodel=prognostic_core(femmodel); 

		displaystring(verbose,'\n%s',['updating geometry...']);
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=UpdateGeometry(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		displaystring(verbose,'\n%s',['updating vertices position...']);
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=UpdateVertexPositions(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		if (solution_type==Transient3DSolutionEnum & mod(step,output_frequency)==0),
			displaystring(verbose,'\n%s',['saving results...']);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,MeltingRateEnum,step,time);
		end
	end
end %end of function
