function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%    Example: md=tres(md,'diagnostic');

%check number of arguments

if strcmpi(string,'diagnostic'),
	md.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
	md.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
	if isfield(md.results.DiagnosticSolution,'Vz'),
		md.vz=PatchToVec(md.results.DiagnosticSolution.Vz);
	else
		md.vz=zeros(md.numberofgrids,1);
	end
	md.vel=PatchToVec(md.results.DiagnosticSolution.Vel);
	if isfield(md.results.DiagnosticSolution,'Pressure'),
		md.pressure=PatchToVec(md.results.DiagnosticSolution.Pressure);
	end
	if md.numrifts,
		if isfield(md.results.DiagnosticSolution,'riftproperties'),
			md.riftproperties=md.results.DiagnosticSolution.riftproperties;
		end
	end
	if md.control_analysis==1,
		md.(md.control_type)=PatchToVec(md.results.DiagnosticSolution.(md.results.DiagnosticSolution.ControlType))
	end
elseif strcmpi(string,'dakota'),
	md.dakotaresults=md.results.dakota;
elseif strcmpi(string,'steadystate'),
	md.vx=PatchToVec(md.results.SteadystateAnalysis.Vx);
	md.vy=PatchToVec(md.results.SteadystateAnalysis.Vy);
	if isfield(md.results.SteadystateAnalysis,'Vz'),
		md.vz=PatchToVec(md.results.SteadystateAnalysis.Vz);
	end

	md.vel=PatchToVec(md.results.SteadystateAnalysis.Vel);
	md.pressure=PatchToVec(md.results.SteadystateAnalysis.Pressure);
	md.temperature=PatchToVec(md.results.SteadystateAnalysis.Temperature);
	md.melting=PatchToVec(md.results.SteadystateAnalysis.Melting);
elseif strcmpi(string,'thermal'),
	md.temperature=PatchToVec(md.results.ThermalAnalysis.Temperature);
	md.melting=PatchToVec(md.results.ThermalAnalysis.Melting);
else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
