#include "stdio.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../objects.h"
#include "../../io/io.h"

/*Constructors/Destructors*/
/*FUNCTION BamgOpts::BamgOpts() {{{1*/
BamgOpts::BamgOpts(){

	this->anisomax=0;
	this->cutoff=0;
	this->coeff=0;
	this->errg=0;
	this->gradation=0;
	this->Hessiantype=0;
	this->MaxCornerAngle=0;
	this->maxnbv=0;
	this->maxsubdiv=0;
	this->Metrictype=0;
	this->nbjacobi=0;
	this->nbsmooth=0;
	this->omega=0;
	this->power=0;
	this->verbose=0;

	this->Crack=0;
	this->geometricalmetric=0;
	this->KeepVertices=0;
	this->splitcorners=0;

	this->hmin=0;
	this->hmax=0;
	this->hminVertices=NULL; this->hminVerticesSize[0]=this->hminVerticesSize[1]=0;
	this->hmaxVertices=NULL; this->hmaxVerticesSize[0]=this->hmaxVerticesSize[1]=0;
	this->hVertices=NULL;    this->hVerticesSize[0]=this->hVerticesSize[1]=0;
	this->metric=NULL;       this->metricSize[0]=this->metricSize[1]=0;
	this->field=NULL;        this->fieldSize[0]=this->fieldSize[1]=0;
	this->err=NULL;          this->errSize[0]=this->errSize[1]=0;

}
/*}}}*/
/*FUNCTION BamgOpts::BamgOpts(mxArray* matlab_struct){{{1*/
#ifdef _SERIAL_
BamgOpts::BamgOpts(mxArray* matlab_struct){

	FetchData(&this->anisomax,mxGetField(matlab_struct,0,"anisomax"));
	FetchData(&this->cutoff,mxGetField(matlab_struct,0,"cutoff"));
	FetchData(&this->coeff,mxGetField(matlab_struct,0,"coeff"));
	FetchData(&this->errg,mxGetField(matlab_struct,0,"errg"));
	FetchData(&this->gradation,mxGetField(matlab_struct,0,"gradation"));
	FetchData(&this->Hessiantype,mxGetField(matlab_struct,0,"Hessiantype"));
	FetchData(&this->MaxCornerAngle,mxGetField(matlab_struct,0,"MaxCornerAngle"));
	FetchData(&this->maxnbv,mxGetField(matlab_struct,0,"maxnbv"));
	FetchData(&this->maxsubdiv,mxGetField(matlab_struct,0,"maxsubdiv"));
	FetchData(&this->Metrictype,mxGetField(matlab_struct,0,"Metrictype"));
	FetchData(&this->nbjacobi,mxGetField(matlab_struct,0,"nbjacobi"));
	FetchData(&this->nbsmooth,mxGetField(matlab_struct,0,"nbsmooth"));
	FetchData(&this->omega,mxGetField(matlab_struct,0,"omega"));
	FetchData(&this->power,mxGetField(matlab_struct,0,"power"));
	FetchData(&this->verbose,mxGetField(matlab_struct,0,"verbose"));

	FetchData(&this->Crack,mxGetField(matlab_struct,0,"Crack"));
	FetchData(&this->geometricalmetric,mxGetField(matlab_struct,0,"geometricalmetric"));
	FetchData(&this->KeepVertices,mxGetField(matlab_struct,0,"KeepVertices"));
	FetchData(&this->splitcorners,mxGetField(matlab_struct,0,"splitcorners"));

	FetchData(&this->hmin,mxGetField(matlab_struct,0,"hmin"));
	FetchData(&this->hmax,mxGetField(matlab_struct,0,"hmax"));
	FetchData(&this->hminVertices,&this->hminVerticesSize[0],&this->hminVerticesSize[1],mxGetField(matlab_struct,0,"hminVertices"));
	FetchData(&this->hmaxVertices,&this->hmaxVerticesSize[0],&this->hmaxVerticesSize[1],mxGetField(matlab_struct,0,"hmaxVertices"));
	FetchData(&this->hVertices,&this->hVerticesSize[0],&this->hVerticesSize[1],mxGetField(matlab_struct,0,"hVertices"));
	FetchData(&this->metric,&this->metricSize[0],&this->metricSize[1],mxGetField(matlab_struct,0,"metric"));
	FetchData(&this->field,&this->fieldSize[0],&this->fieldSize[1],mxGetField(matlab_struct,0,"field"));
	FetchData(&this->err,&this->errSize[0],&this->errSize[1],mxGetField(matlab_struct,0,"err"));

	/*Additional checks*/
	this->Check();

}
#endif
/*}}}*/
/*FUNCTION BamgOpts::~BamgOpts() {{{1*/
BamgOpts::~BamgOpts(){

	xfree((void**)&this->hminVertices);
	xfree((void**)&this->hmaxVertices);
	xfree((void**)&this->hVertices);
	xfree((void**)&this->metric);
	xfree((void**)&this->field);
	xfree((void**)&this->err);

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgOpts::Check{{{1*/
void BamgOpts::Check(void){

	int i;

	if (this->anisomax<1) ISSMERROR("'anisomax' option should be >=1");
	if (this->coeff==0) ISSMERROR("'coeff' should be positive");
	if (this->errg<0) ISSMERROR("'errg' option should be >0");
	if (this->gradation<1) ISSMERROR("'gradation' option should be >=1");
	if (this->Hessiantype!=0  && this->Hessiantype!=1) ISSMERROR("'Hessiantype' supported options are 0 and 1");
	if (this->maxnbv<3) ISSMERROR("'maxnbv' option should be >3");
	if (this->maxsubdiv<=1) ISSMERROR("'maxsubdiv' should be >1");
	if (this->Metrictype!=0   && this->Metrictype!=1 && this->Metrictype!=2) ISSMERROR("'Metrictype' supported options are 0, 1 and 2");
	if (this->nbjacobi<=0) ISSMERROR("'nbjacobi' option should be >0");
	if (this->nbsmooth<=0) ISSMERROR("'nbsmooth' option should be >0");

	if (this->Crack!=0  && this->Crack!=1) ISSMERROR("'Crack' supported options are 0 and 1");
	if (this->KeepVertices!=0 && this->KeepVertices!=1) ISSMERROR("'KeepVertices' supported options are 0 and 1");
	if (this->geometricalmetric!=0  && this->geometricalmetric!=1) ISSMERROR("'geometricalmetric' supported options are 0 and 1");

	if (this->hmin<=0) ISSMERROR("'hmin' option should be >0");
	if (this->hmax<=0 || this->hmax<this->hmin) ISSMERROR("'hmax' option should be between 0 and hmin=%g",this->hmin);
	if (this->hminVertices && this->hminVerticesSize[1]!=1) ISSMERROR("'hminVertices' should be a column");
	if (this->hmaxVertices && this->hmaxVerticesSize[1]!=1) ISSMERROR("'hmaxVertices' should be a column");
	if (this->hVertices && this->hVerticesSize[1]!=1) ISSMERROR("'hVertices' should be a column");
	if (this->metric && (this->metricSize[1]!=1 && this->metricSize[1]!=3)) ISSMERROR("'metric' should have either 1 (iso) or 3 (aniso) columns.");
	if (this->field){
		if (this->errSize[0]!=1 || this->errSize[1]!=this->fieldSize[1]) ISSMERROR("'err' should be of size %i x %i",1,this->fieldSize[1]);
		for (i=0;i<this->fieldSize[1];i++) {if (this->err[i]<=0) ISSMERROR("'err' option should be >0");};
	}

}
/*}}}*/
