/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*Outputs*/
	mxArray* bamgmesh_mat=NULL;
	mxArray* bamggeom_mat=NULL;

	/*diverse: */
	BamgOpts *bamgopts=NULL;
	BamgMesh *bamgmesh_in=NULL;
	BamgGeom *bamggeom_in=NULL;
	BamgMesh *bamgmesh_out=NULL;
	BamgGeom *bamggeom_out=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*Initialize variables*/
	bamgopts   = new BamgOpts(BAMGOPTIONS);
	bamggeom_in= new BamgGeom(BAMGGEOMIN);
	bamgmesh_in= new BamgMesh(BAMGMESHIN);

	/*Initialize outputs*/
	bamggeom_out=new BamgGeom();
	bamgmesh_out=new BamgMesh();

	/*!Generate internal degree of freedom numbers: */
	Bamgx(bamgmesh_out,bamggeom_out,bamgmesh_in,bamggeom_in,bamgopts);

	/*Generate output Matlab Structures*/
	bamggeom_out->SetMatlabStructureFields(BAMGGEOMOUT);
	bamgmesh_out->SetMatlabStructureFields(BAMGMESHOUT);

	/*Free ressources: */
	delete bamgopts;
	delete bamggeom_in;
	delete bamggeom_out;
	delete bamgmesh_in;
	delete bamgmesh_out;

	/*end module: */
	MODULEEND();
}

void BamgUsage(void){
	_printf_("\n");
	_printf_("   usage: [bamgmesh,bamggeom]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
