/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, QuadTree.h)*/
#ifndef _QUADTREE_H
#define _QUADTREE_H

#include "./include.h"

namespace bamg {

	const int  MaxDeep  = 30;
	const long MaxISize = ( 1L << MaxDeep);  // = 2^30 : 010000000000..000 (bitwise operation)

	class Mesh;
	class BamgVertex;

	class QuadTree{

		private:

			class QuadTreeBox{ 
				/*A quadtree box contains a maximum of 4 vertices. 4 other quadtree boxes are
				 * created if a fifth vertex is added to the same box. A Quadtree box is therefore
				 * composed of EITHER:
				 * - up to 4 vertices
				 * - 4 "sub" quadtree boxes*/

				public:

					int nbitems; // number of current vertices in the box

					union{
						QuadTreeBox* b[4];
						BamgVertex*  v[4];
					};
			};

			class StorageQuadTreeBox{

				public:

					/*Fields*/
					QuadTreeBox        *boxes,*firstbox,*lastbox;
					long                nbquadtreeboxes;
					StorageQuadTreeBox *nextsb;         // next StorageQuadTreeBox

					/*Methods*/
					StorageQuadTreeBox(long ,StorageQuadTreeBox* =NULL);
					~StorageQuadTreeBox();
					long  SizeOf() const;
			};

			/*QuadTree private Fields*/
			StorageQuadTreeBox* sb;
			long                lenStorageQuadTreeBox;

		public:

			/*QuadTree public Fields*/
			QuadTreeBox* root;
			Mesh*        th;
			long         NbQuadTreeBox;
			long         NbVertices;

			QuadTree();
			QuadTree(Mesh *t,long nbv=-1);
			~QuadTree();

			BamgVertex*  NearestVertex(Icoor1 i,Icoor1 j);
			BamgVertex*  NearestVertexWithNormal(Icoor1 i,Icoor1 j);
			QuadTreeBox* NewQuadTreeBox(void);
			BamgVertex*  ToClose(BamgVertex & ,double ,Icoor1,Icoor1);
			long         SizeOf() const;
			void         Add( BamgVertex & w);

	};
}
#endif
