function fields=testsgetfields(mdtype,string),
%TESTSGETfields - build the fields to be checked from a string
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input string 'prognostic', it will output 'cielo'
%
%   Usage:
%      fields=testsgetfields(mdtype,string)
%
%   Example:
%      fields=testsgetfields(md.type,'diagnostic')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

if strcmpi(string,'diagnostic'),
	if strcmpi(mdtype,'3d')
		fields={'vy','vz'};
	else
		fields={'vel'};
	end

elseif strcmpi(string,'thermalsteady'),
	fields={'temperature','melting'};

elseif strcmpi(string,'thermaltransient'),
	fields={'thermaltransient_results(end).temperature','thermaltransient_results(end).melting'};

elseif strcmpi(string,'prognostic'),
	fields={'new_thickness'};

elseif strcmpi(string,'transient'), 
	if strcmpi(mdtype,'3d')
		fields={'transient_results(end).vy','transient_results(end).vz','transient_results(end).temperature','transient_results(end).melting','transient_results(end).thickness'};
	else
		fields={'transient_results(end).vel','transient_results(end).thickness'};
	end

else
	error(['testsgetfields error message: solution '  string ' not supported yet']);
end
