%This test is a test from the ISMP-HOM Intercomparison project
%TestE 
Lx=10; %in m
Ly=5000; %in m
nx=3; %number of nodes in x direction
ny=51;
md=model;
md=squaremesh(md,Lx,Ly,nx,ny);
md=geography(md,'',''); %ice sheet test
md=parameterize(md,'../Par/ISMIPE.par');
md=extrude(md,10,1);

md=setelementstype(md,'pattyn','all');
%md=setelementstype(md,'pattyn','all','stokes','all'); 

%md.gridonstokes(find(md.x==0 | md.x==Lx))=0;
%%Create MPCs to have periodic boundary conditions
%posx=find(md.x==0);
%posx2=find(md.x==max(md.x));
%
%md.penalties=[posx,posx2];

%Compute the diagnostic
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

vx=PatchToVec(md.results.DiagnosticSolution.Vx);
vy=PatchToVec(md.results.DiagnosticSolution.Vy);
vz=PatchToVec(md.results.DiagnosticSolution.Vz);

plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.numlayers)
