/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, QuadTree.h)*/
#ifndef _QUADTREE_H
#define _QUADTREE_H

#include "./include.h"

namespace bamg {

	const int  MaxDeep  = 30;
	const long MaxISize = ( 1L << MaxDeep);  // = 2^30 : 010000000000..000 (bitwise operation)

	class Mesh;
	class BamgVertex;

	class QuadTree{

		private:

			class QuadTreeBox{ 
				/*A quadtree box contains a maximum of 4 vertices. 4 other quadtree boxes are
				 * created if a fifth vertex is added to the same box. A Quadtree box is therefore
				 * composed of EITHER:
				 * - up to 4 vertices
				 * - 4 "sub" quadtree boxes*/

				public:

					int n; // number of current vertices in the box

					union{
						QuadTreeBox* b[4];
						BamgVertex*  v[4];
					};
			};

			class StorageQuadTreeBox{

				public:

					/*Fields*/
					QuadTreeBox *b,*bc,*be;
					long len;
					StorageQuadTreeBox* n; // next StorageQuadTreeBox

					/*Methods*/
					StorageQuadTreeBox(long ,StorageQuadTreeBox* =NULL);
					~StorageQuadTreeBox() {
						if(n) delete n;
						delete [] b;
					}
					long  SizeOf() const {return len*sizeof(QuadTreeBox)+sizeof(StorageQuadTreeBox)+ (n?n->SizeOf():0);}
			};

			/*QuadTree private Fields*/
			StorageQuadTreeBox* sb;
			long                lenStorageQuadTreeBox;

		public:

			/*QuadTree public Fields*/
			QuadTreeBox* root;
			Mesh*        th;
			long         NbQuadTreeBox,NbVertices;
			long         NbQuadTreeBoxSearch,NbVerticesSearch;

			QuadTree(Mesh *t,long nbv=-1);
			QuadTree();
			~QuadTree();
			BamgVertex* NearestVertex(Icoor1 i,Icoor1 j);
			BamgVertex* NearestVertexWithNormal(Icoor1 i,Icoor1 j);
			BamgVertex* ToClose(BamgVertex & ,double ,Icoor1,Icoor1);
			long    SizeOf() const;
			void    Add( BamgVertex & w);

			/*The following function cannot be in the cpp file because QuadTreeBox is
			 * a private class and is declared before QuadTree::*/
			QuadTreeBox* NewQuadTreeBox(void){

				/*if bc==be or bc>be (we have reach the end of the StorageQuadTreeBox)
				 * create a new StorageQuadTreeBox)*/
				if(!(sb->bc<sb->be)){
					sb=new StorageQuadTreeBox(lenStorageQuadTreeBox,sb);
				}
				ISSMASSERT(sb && sb->bc->n==0);

				/*Increase counter*/
				NbQuadTreeBox++;

				/*bc now points toward next quadtree box*/
				return sb->bc++;

			}
	};
}
#endif
