#include "stdio.h"
#include "../objects.h"
#include "../../io/io.h"

/*Constructors/Destructors*/
/*FUNCTION BamgMesh::BamgMesh(){{{1*/
BamgMesh::BamgMesh(){

	this->VerticesSize[0]=0,                  this->VerticesSize[1]=0;                 this->Vertices=NULL;
	this->EdgesSize[0]=0,                     this->EdgesSize[1]=0;                    this->Edges=NULL;
	this->TrianglesSize[0]=0,                 this->TrianglesSize[1]=0;                this->Triangles=NULL;
	this->QuadrilateralsSize[0]=0,            this->QuadrilateralsSize[1]=0;           this->Quadrilaterals=NULL;

	this->SubDomainsSize[0]=0,                this->SubDomainsSize[1]=0;               this->SubDomains=NULL;
	this->SubDomainsFromGeomSize[0]=0,        this->SubDomainsFromGeomSize[1]=0;       this->SubDomainsFromGeom=NULL;
	this->CrackedVerticesSize[0]=0,           this->CrackedVerticesSize[1]=0;          this->CrackedVertices=NULL;
	this->CrackedEdgesSize[0]=0,              this->CrackedEdgesSize[1]=0;             this->CrackedEdges=NULL;

	this->VerticesOnGeometricVertexSize[0]=0, this->VerticesOnGeometricVertexSize[1]=0;this->VerticesOnGeometricVertex=NULL;
	this->VerticesOnGeometricEdgeSize[0]=0,   this->VerticesOnGeometricEdgeSize[1]=0;  this->VerticesOnGeometricEdge=NULL;
	this->EdgesOnGeometricEdgeSize[0]=0,      this->EdgesOnGeometricEdgeSize[1]=0;     this->EdgesOnGeometricEdge=NULL;

	this->hVertices=NULL;

	this->IssmEdgesSize[0]=0,                 this->IssmEdgesSize[1]=0;                this->IssmEdges=NULL;
	this->IssmSegmentsSize[0]=0,              this->IssmSegmentsSize[1]=0;             this->IssmSegments=NULL;

	this->ElementConnectivitySize[0]=0,       this->ElementConnectivitySize[1]=0;      this->ElementConnectivity=NULL;
	this->NodalConnectivitySize[0]=0,         this->NodalConnectivitySize[1]=0;        this->NodalConnectivity=NULL;
	this->NodalElementConnectivitySize[0]=0,  this->NodalElementConnectivitySize[1]=0; this->NodalElementConnectivity=NULL;


}
/*}}}*/
/*FUNCTION BamgMesh::BamgMesh(mxArray* matlab_struct){{{1*/
#ifdef _SERIAL_
BamgMesh::BamgMesh(mxArray* matlab_struct){

	int lines,cols;

	FetchData(&this->Vertices,                 &this->VerticesSize[0],                 &this->VerticesSize[1],                 mxGetField(matlab_struct,0,"Vertices"));
	FetchData(&this->Edges,                    &this->EdgesSize[0],                    &this->EdgesSize[1],                    mxGetField(matlab_struct,0,"Edges"));
	FetchData(&this->Triangles,                &this->TrianglesSize[0],                &this->TrianglesSize[1],                mxGetField(matlab_struct,0,"Triangles"));
	this->QuadrilateralsSize[0]=0,            this->QuadrilateralsSize[1]=0;           this->Quadrilaterals=NULL;

	this->SubDomainsSize[0]=0,                this->SubDomainsSize[1]=0;               this->SubDomains=NULL;
	this->SubDomainsFromGeomSize[0]=0,        this->SubDomainsFromGeomSize[1]=0;       this->SubDomainsFromGeom=NULL;
	this->CrackedVerticesSize[0]=0,           this->CrackedVerticesSize[1]=0;          this->CrackedVertices=NULL;
	FetchData(&this->CrackedEdges,            &this->CrackedEdgesSize[0],              &this->CrackedEdgesSize[1],             mxGetField(matlab_struct,0,"CrackedEdges"));

	FetchData(&this->VerticesOnGeometricEdge,  &this->VerticesOnGeometricEdgeSize[0],  &this->VerticesOnGeometricEdgeSize[1],  mxGetField(matlab_struct,0,"VerticesOnGeometricEdge"));
	FetchData(&this->VerticesOnGeometricVertex,&this->VerticesOnGeometricVertexSize[0],&this->VerticesOnGeometricVertexSize[1],mxGetField(matlab_struct,0,"VerticesOnGeometricVertex"));
	FetchData(&this->EdgesOnGeometricEdge,     &this->EdgesOnGeometricEdgeSize[0],     &this->EdgesOnGeometricEdgeSize[1],     mxGetField(matlab_struct,0,"EdgesOnGeometricEdge"));

	FetchData(&this->hVertices,                &lines,                                 &cols,                                  mxGetField(matlab_struct,0,"hVertices"));

	this->IssmEdgesSize[0]=0,                 this->IssmEdgesSize[1]=0;                this->IssmEdges=NULL;
	FetchData(&this->IssmSegments,             &this->IssmSegmentsSize[0],             &this->IssmSegmentsSize[1],             mxGetField(matlab_struct,0,"IssmSegments"));

	this->ElementConnectivitySize[0]=0,       this->ElementConnectivitySize[1]=0;      this->ElementConnectivity=NULL;
	this->NodalConnectivitySize[0]=0,         this->NodalConnectivitySize[1]=0;        this->NodalConnectivity=NULL;
	this->NodalElementConnectivitySize[0]=0,  this->NodalElementConnectivitySize[1]=0; this->NodalElementConnectivity=NULL;

	/*Checks*/
	if (this->hVertices && (cols!=1 || lines!=this->VerticesSize[0])){ISSMERROR("the size of 'hVertices' should be [%i %i]",this->VerticesSize[0],1);}

}
#endif
/*}}}*/
/*FUNCTION BamgMesh::~BamgMesh(){{{1*/
BamgMesh::~BamgMesh(){

	xfree((void**)&this->Vertices);
	xfree((void**)&this->Edges);
	xfree((void**)&this->Triangles);
	xfree((void**)&this->Quadrilaterals);

	xfree((void**)&this->SubDomains);
	xfree((void**)&this->SubDomainsFromGeom);
	xfree((void**)&this->CrackedVertices);
	xfree((void**)&this->CrackedEdges);

	xfree((void**)&this->VerticesOnGeometricVertex);
	xfree((void**)&this->VerticesOnGeometricEdge);
	xfree((void**)&this->EdgesOnGeometricEdge);

	xfree((void**)&this->hVertices);

	xfree((void**)&this->IssmEdges);
	xfree((void**)&this->IssmSegments);

	xfree((void**)&this->ElementConnectivity);
	xfree((void**)&this->NodalConnectivity);
	xfree((void**)&this->NodalElementConnectivity);


}
/*}}}*/

/*Methods*/
/*FUNCTION BamgMesh::SetMatlabStructureFields{{{1*/
#ifdef _SERIAL_
void BamgMesh::SetMatlabStructureFields(mxArray** matlab_struct){

	/*Intermediary*/
	int         i;
	mxArray*    output=NULL;
	int         numfields=16;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	/*Initialize field names*/
	i=0;
	fnames[i++] = "Triangles";
	fnames[i++] = "Vertices";
	fnames[i++] = "Edges";
	fnames[i++] = "IssmSegments";
	fnames[i++] = "IssmEdges";
	fnames[i++] = "Quadrilaterals";
	fnames[i++] = "VerticesOnGeometricVertex";
	fnames[i++] = "VerticesOnGeometricEdge";
	fnames[i++] = "EdgesOnGeometricEdge";
	fnames[i++] = "SubDomains";
	fnames[i++] = "SubDomainsFromGeom";
	fnames[i++] = "ElementConnectivity";
	fnames[i++] = "NodalConnectivity";
	fnames[i++] = "NodalElementConnectivity";
	fnames[i++] = "CrackedVertices";
	fnames[i++] = "CrackedEdges";
	ISSMASSERT(i==numfields);

	/*Initialize Matlab structure*/
	output=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	/*set each matlab each field*/
	i=0;
	i++; SetMatlabStructureField(output,"Triangles",                this->TrianglesSize[0],                this->TrianglesSize[1],                 this->Triangles);
	i++; SetMatlabStructureField(output,"Vertices",                 this->VerticesSize[0],                 this->VerticesSize[1],                  this->Vertices);
	i++; SetMatlabStructureField(output,"Edges",                    this->EdgesSize[0],                    this->EdgesSize[1],                     this->Edges);
	i++; SetMatlabStructureField(output,"IssmSegments",             this->IssmSegmentsSize[0],             this->IssmSegmentsSize[1],              this->IssmSegments);
	i++; SetMatlabStructureField(output,"IssmEdges",                this->IssmEdgesSize[0],                this->IssmEdgesSize[1],                 this->IssmEdges);
	i++; SetMatlabStructureField(output,"Quadrilaterals",           this->QuadrilateralsSize[0],           this->QuadrilateralsSize[1],            this->Quadrilaterals);
	i++; SetMatlabStructureField(output,"VerticesOnGeometricVertex",this->VerticesOnGeometricVertexSize[0],this->VerticesOnGeometricVertexSize[1], this->VerticesOnGeometricVertex);
	i++; SetMatlabStructureField(output,"VerticesOnGeometricEdge",  this->VerticesOnGeometricEdgeSize[0],  this->VerticesOnGeometricEdgeSize[1],   this->VerticesOnGeometricEdge);
	i++; SetMatlabStructureField(output,"EdgesOnGeometricEdge",     this->EdgesOnGeometricEdgeSize[0],     this->EdgesOnGeometricEdgeSize[1],      this->EdgesOnGeometricEdge);
	i++; SetMatlabStructureField(output,"SubDomains",               this->SubDomainsSize[0],               this->SubDomainsSize[1],                this->SubDomains);
	i++; SetMatlabStructureField(output,"SubDomainsFromGeom",       this->SubDomainsFromGeomSize[0],       this->SubDomainsFromGeomSize[1],        this->SubDomainsFromGeom);
	i++; SetMatlabStructureField(output,"ElementConnectivity",      this->ElementConnectivitySize[0],      this->ElementConnectivitySize[1],       this->ElementConnectivity);
	i++; SetMatlabStructureField(output,"NodalConnectivity",        this->NodalConnectivitySize[0],        this->NodalConnectivitySize[1],         this->NodalConnectivity);
	i++; SetMatlabStructureField(output,"NodalElementConnectivity", this->NodalElementConnectivitySize[0], this->NodalElementConnectivitySize[1],  this->NodalElementConnectivity);
	i++; SetMatlabStructureField(output,"CrackedVertices",          this->CrackedVerticesSize[0],          this->CrackedVerticesSize[1],           this->CrackedVertices);
	i++; SetMatlabStructureField(output,"CrackedEdges",             this->CrackedEdgesSize[0],             this->CrackedEdgesSize[1],              this->CrackedEdges);
	ISSMASSERT(i==numfields);

	/*Assign output*/
	*matlab_struct=output;

}
#endif
/*}}}*/
/*FUNCTION BamgMesh::SetMatlabStructureField{{{1*/
#ifdef _SERIAL_
void BamgMesh::SetMatlabStructureField(mxArray* matlab_struct,const char* fieldname,int fieldrows,int fieldcols,double* fieldpointer){

	/*Intermediary*/
	int         i1,i2;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;

	/*Copy field*/
	double*  fieldcopy=NULL;
	if (fieldrows*fieldcols){
		fieldcopy=(double*)xmalloc(fieldrows*fieldcols*sizeof(double));
		for(i1=0;i1<fieldrows;i1++){
			for(i2=0;i2<fieldcols;i2++){
				fieldcopy[fieldcols*i1+i2]=fieldpointer[fieldcols*i1+i2];
			}
		}
	}

	/*Set matlab field*/
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,fieldcols);
	mxSetN(pfield,fieldrows);
	mxSetPr(pfield,fieldcopy);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(matlab_struct,0,fieldname,pfield2);
}
#endif
/*}}}*/
