/*!\file:  BamgOpts.h
 * \brief place holder for optimization function arguments
 */ 

#ifndef _BAMGOPTS_H_
#define _BAMGOPTS_H_

#ifdef _SERIAL_
#include <mex.h>
#endif

class BamgOpts{

	public:

		int     maxnbv;
		double  MaxCornerAngle;
		int     Crack;
		int     Hessiantype;
		int     Metrictype;
		int     KeepVertices;
		double  maxsubdiv;
		double  power;
		double  anisomax;
		int     nbsmooth;
		int     nbjacobi;
		double  omega;
		double  hmin;
		double  hmax;
		double* hminVertices;
		double* hmaxVertices;
		double  gradation;
		double  cutoff;
		int     splitcorners;
		int     geometricalmetric;
		int     verbose;
		double* err;
		double  errg;
		double  coeff;
		double* metric;
		double* field;
		int     numfields;

		BamgOpts();
		#ifdef _SERIAL_
		BamgOpts(mxArray* matlab_struct);
		#endif
		~BamgOpts();

		void Check(void);

};
#endif
