#include "stdio.h"
#include "../objects.h"
#include "../../io/io.h"

/*Constructors/Destructors*/
/*FUNCTION BamgGeom::BamgGeom(){{{1*/
BamgGeom::BamgGeom(){

	this->VerticesSize[0]=0,          this->VerticesSize[1]=0;          this->Vertices=NULL;
	this->EdgesSize[0]=0,             this->EdgesSize[1]=0;             this->Edges=NULL;
	this->hVertices=NULL;
	this->MetricVertices=NULL;
	this->TangentAtEdgesSize[0]=0,    this->TangentAtEdgesSize[1]=0;    this->TangentAtEdges=NULL;
	this->CornersSize[0]=0,           this->CornersSize[1]=0;           this->Corners=NULL;
	this->RequiredVerticesSize[0]=0,  this->RequiredVerticesSize[1]=0;  this->RequiredVertices=NULL;
	this->RequiredEdgesSize[0]=0,     this->RequiredEdgesSize[1]=0;     this->RequiredEdges=NULL;
	this->CrackedEdgesSize[0]=0,      this->CrackedEdgesSize[1]=0;      this->CrackedEdges=NULL;
	this->SubDomainsSize[0]=0,        this->SubDomainsSize[1]=0;        this->SubDomains=NULL;

}
/*}}}*/
/*FUNCTION BamgGeom::BamgGeom(mxArray* matlab_struct){{{1*/
#ifdef _SERIAL_
BamgGeom::BamgGeom(mxArray* matlab_struct){

	int lines,cols;

	FetchData(&this->Vertices,        &this->VerticesSize[0],        &this->VerticesSize[1],        mxGetField(matlab_struct,0,"Vertices"));
	FetchData(&this->Edges,           &this->EdgesSize[0],           &this->EdgesSize[1],           mxGetField(matlab_struct,0,"Edges"));
	FetchData(&this->hVertices,&lines,&cols,mxGetField(matlab_struct,0,"hVertices"));
	this->MetricVertices=NULL;
	this->TangentAtEdgesSize[0]=0,    this->TangentAtEdgesSize[1]=0;    this->TangentAtEdges=NULL;
	FetchData(&this->Corners,         &this->CornersSize[0],         &this->CornersSize[1],         mxGetField(matlab_struct,0,"Corners"));
	FetchData(&this->RequiredVertices,&this->RequiredVerticesSize[0],&this->RequiredVerticesSize[1],mxGetField(matlab_struct,0,"RequiredVertices"));
	FetchData(&this->RequiredEdges,   &this->RequiredEdgesSize[0],   &this->RequiredEdgesSize[1],   mxGetField(matlab_struct,0,"RequiredEdges"));
	FetchData(&this->CrackedEdges,    &this->CrackedEdgesSize[0],    &this->CrackedEdgesSize[1],    mxGetField(matlab_struct,0,"CrackedEdges"));
	FetchData(&this->SubDomains,      &this->SubDomainsSize[0],      &this->SubDomainsSize[1],      mxGetField(matlab_struct,0,"SubDomains"));

	/*Some checks*/
	if (this->hVertices && (cols!=1 || lines!=this->VerticesSize[0])){ISSMERROR("the size of 'hVertices' should be [%i %i]",this->VerticesSize[0],1);}

}
#endif
/*}}}*/
/*FUNCTION BamgGeom::~BamgGeom(){{{1*/
BamgGeom::~BamgGeom(){

	xfree((void**)&this->Vertices);
	xfree((void**)&this->Edges);
	xfree((void**)&this->hVertices);
	xfree((void**)&this->MetricVertices);
	xfree((void**)&this->TangentAtEdges);
	xfree((void**)&this->Corners);
	xfree((void**)&this->RequiredVertices);
	xfree((void**)&this->RequiredEdges);
	xfree((void**)&this->CrackedEdges);
	xfree((void**)&this->SubDomains);

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgGeom::SetMatlabStructureFields{{{1*/
#ifdef _SERIAL_
void BamgGeom::SetMatlabStructureFields(mxArray** matlab_struct){

	/*Intermediary*/
	int         i;
	mxArray*    output=NULL;
	int         numfields=7;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	/*Initialize field names*/
	i=0;
	fnames[i++] = "Vertices";
	fnames[i++] = "Edges";
	fnames[i++] = "TangentAtEdges";
	fnames[i++] = "RequiredVertices";
	fnames[i++] = "RequiredEdges";
	fnames[i++] = "CrackedEdges";
	fnames[i++] = "SubDomains";
	ISSMASSERT(i==numfields);

	/*Initialize Matlab structure*/
	output=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	/*set each matlab each field*/
	i=0;
	i++; SetMatlabStructureField(output,"Vertices",        this->VerticesSize[0],        this->VerticesSize[1],        this->Vertices);
	i++; SetMatlabStructureField(output,"Edges",           this->EdgesSize[0],           this->EdgesSize[1],           this->Edges);
	i++; SetMatlabStructureField(output,"TangentAtEdges",  this->TangentAtEdgesSize[0],  this->TangentAtEdgesSize[1],  this->TangentAtEdges);
	i++; SetMatlabStructureField(output,"RequiredVertices",this->RequiredVerticesSize[0],this->RequiredVerticesSize[1],this->RequiredVertices);
	i++; SetMatlabStructureField(output,"RequiredEdges",   this->RequiredEdgesSize[0],   this->RequiredEdgesSize[1],   this->RequiredEdges);
	i++; SetMatlabStructureField(output,"CrackedEdges",    this->CrackedEdgesSize[0],    this->CrackedEdgesSize[1],    this->CrackedEdges);
	i++; SetMatlabStructureField(output,"SubDomains",      this->SubDomainsSize[0],      this->SubDomainsSize[1],      this->SubDomains);
	ISSMASSERT(i==numfields);

	/*Assign output*/
	*matlab_struct=output;

}
#endif
/*}}}*/
/*FUNCTION BamgGeom::SetMatlabStructureField{{{1*/
#ifdef _SERIAL_
void BamgGeom::SetMatlabStructureField(mxArray* matlab_struct,const char* fieldname,int fieldrows,int fieldcols,double* fieldpointer){

	/*Intermediary*/
	int         i1,i2;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;

	/*Copy field*/
	double*  fieldcopy=NULL;
	if (fieldrows*fieldcols){
		fieldcopy=(double*)xmalloc(fieldrows*fieldcols*sizeof(double));
		for(i1=0;i1<fieldrows;i1++){
			for(i2=0;i2<fieldcols;i2++){
				fieldcopy[fieldcols*i1+i2]=fieldpointer[fieldcols*i1+i2];
			}
		}
	}

	/*Set matlab field*/
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,fieldcols);
	mxSetN(pfield,fieldrows);
	mxSetPr(pfield,fieldcopy);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(matlab_struct,0,fieldname,pfield2);
}
#endif
/*}}}*/
