/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*Outputs*/
	mxArray* bamgmesh_mat=NULL;
	mxArray* bamggeom_mat=NULL;

	/*diverse: */
	int   i;
	int   lines,cols;
	BamgOpts *bamgopts=NULL;
	BamgMesh *bamgmesh_in=NULL;
	BamgGeom *bamggeom_in=NULL;
	BamgMesh *bamgmesh_out=NULL;
	BamgGeom *bamggeom_out=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*Initialize variables*/
	bamgopts=new BamgOpts;
	bamggeom_in=new BamgGeom;
	bamgmesh_in=new BamgMesh;
	bamggeom_out=new BamgGeom;
	bamgmesh_out=new BamgMesh;

	/*Build objects from matlab structures*/
	bamggeom_in->GetMatlabStructureFields(BAMGGEOMETRY);
	bamgmesh_in->GetMatlabStructureFields(BAMGMESH);

	/*create bamg options input*/
	FetchData(&bamgopts->coeff,mxGetField(BAMGOPTIONS,0,"coeff"));
	FetchData(&bamgopts->maxsubdiv,mxGetField(BAMGOPTIONS,0,"maxsubdiv"));
	FetchData(&bamgopts->Crack,mxGetField(BAMGOPTIONS,0,"Crack"));
	FetchData(&bamgopts->Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	FetchData(&bamgopts->Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	FetchData(&bamgopts->KeepVertices,mxGetField(BAMGOPTIONS,0,"KeepVertices"));
	FetchData(&bamgopts->power,mxGetField(BAMGOPTIONS,0,"power"));
	FetchData(&bamgopts->errg,mxGetField(BAMGOPTIONS,0,"errg"));
	FetchData(&bamgopts->nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	FetchData(&bamgopts->nbsmooth,mxGetField(BAMGOPTIONS,0,"nbsmooth"));
	FetchData(&bamgopts->omega,mxGetField(BAMGOPTIONS,0,"omega"));
	FetchData(&bamgopts->maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	FetchData(&bamgopts->hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	FetchData(&bamgopts->hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	FetchData(&bamgopts->anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	FetchData(&bamgopts->gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	FetchData(&bamgopts->cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	FetchData(&bamgopts->verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	FetchData(&bamgopts->splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	FetchData(&bamgopts->geometricalmetric,mxGetField(BAMGOPTIONS,0,"geometricalmetric"));
	FetchData(&bamgopts->MaxCornerAngle,mxGetField(BAMGOPTIONS,0,"MaxCornerAngle"));
	FetchData(&bamgopts->hminVertices,&lines,&cols,mxGetField(BAMGOPTIONS,0,"hminVertices"));
	if (bamgopts->hminVertices && (cols!=1 || lines!=bamgmesh_in->VerticesSize[0])){ISSMERROR("the size of 'hminVertices' should be [%i %i]",bamgmesh_in->VerticesSize[0],1);}
	FetchData(&bamgopts->hmaxVertices,&lines,&cols,mxGetField(BAMGOPTIONS,0,"hmaxVertices"));
	if (bamgopts->hmaxVertices && (cols!=1 || lines!=bamgmesh_in->VerticesSize[0])){ISSMERROR("the size of 'hmaxVertices' should be [%i %i]",bamgmesh_in->VerticesSize[0],1);}
	FetchData(&bamgopts->metric,&lines,&cols,mxGetField(BAMGOPTIONS,0,"metric"));
	if (bamgopts->metric && (cols!=3 || lines!=bamgmesh_in->VerticesSize[0])){ISSMERROR("the size of 'metric' should be [%i %i]",bamgmesh_in->VerticesSize[0],3);}
	FetchData(&bamgopts->field,&lines,&bamgopts->numfields,mxGetField(BAMGOPTIONS,0,"field"));
	if (bamgopts->field && lines!=bamgmesh_in->VerticesSize[0]){ISSMERROR("the size of 'field' should be [%i %i]",bamgmesh_in->VerticesSize[0],bamgopts->numfields);}
	FetchData(&bamgopts->err,NULL,&cols,mxGetField(BAMGOPTIONS,0,"err"));
	if (bamgopts->numfields!=0 && cols!=bamgopts->numfields){ISSMERROR("the size of 'err' should be the same as 'field'");}
	bamgopts->Check();

	/*!Generate internal degree of freedom numbers: */
	Bamgx(bamgmesh_out,bamggeom_out,bamgmesh_in,bamggeom_in,bamgopts);

	/*Generate output Matlab Structures*/
	bamggeom_out->SetMatlabStructureFields(BAMGGEOMOUT);
	bamgmesh_out->SetMatlabStructureFields(BAMGMESHOUT);

	/*Free ressources: */
	delete bamgopts;
	delete bamggeom_in;
	delete bamggeom_out;
	delete bamgmesh_in;
	delete bamgmesh_out;

	/*end module: */
	MODULEEND();
}

void BamgUsage(void){
	_printf_("\n");
	_printf_("   usage: [bamgmesh,bamggeom]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
