#include "stdio.h"
#include "../objects.h"
#include "../../io/io.h"

/*Constructors/Destructors*/
/*FUNCTION BamgMesh::BamgMesh(){{{1*/
BamgMesh::BamgMesh(){

	this->VerticesSize[0]=0,                  this->VerticesSize[1]=0;                 this->Vertices=NULL;
	this->EdgesSize[0]=0,                     this->EdgesSize[1]=0;                    this->Edges=NULL;
	this->TrianglesSize[0]=0,                 this->TrianglesSize[1]=0;                this->Triangles=NULL;
	this->QuadrilateralsSize[0]=0,            this->QuadrilateralsSize[1]=0;           this->Quadrilaterals=NULL;
	this->VerticesOnGeometricVertexSize[0]=0, this->VerticesOnGeometricVertexSize[1]=0;this->VerticesOnGeometricVertex=NULL;
	this->VerticesOnGeometricEdgeSize[0]=0,   this->VerticesOnGeometricEdgeSize[1]=0;  this->VerticesOnGeometricEdge=NULL;
	this->EdgesOnGeometricEdgeSize[0]=0,      this->EdgesOnGeometricEdgeSize[1]=0;     this->EdgesOnGeometricEdge=NULL;
	this->SubDomainsSize[0]=0,                this->SubDomainsSize[1]=0;               this->SubDomains=NULL;
	this->SubDomainsFromGeomSize[0]=0,        this->SubDomainsFromGeomSize[1]=0;       this->SubDomainsFromGeom=NULL;
	this->hVertices=NULL;
	this->IssmEdgesSize[0]=0,                 this->IssmEdgesSize[1]=0;                this->IssmEdges=NULL;
	this->IssmSegmentsSize[0]=0,              this->IssmSegmentsSize[1]=0;             this->IssmSegments=NULL;
	this->ElementConnectivitySize[0]=0,       this->ElementConnectivitySize[1]=0;      this->ElementConnectivity=NULL;
	this->NodalConnectivitySize[0]=0,         this->NodalConnectivitySize[1]=0;        this->NodalConnectivity=NULL;
	this->NodalElementConnectivitySize[0]=0,  this->NodalElementConnectivitySize[1]=0; this->NodalElementConnectivity=NULL;
	this->CrackedVerticesSize[0]=0,           this->CrackedVerticesSize[1]=0;          this->CrackedVertices=NULL;
	this->CrackedEdgesSize[0]=0,              this->CrackedEdgesSize[1]=0;             this->CrackedEdges=NULL;

}
/*}}}*/
/*FUNCTION BamgMesh::~BamgMesh(){{{1*/
BamgMesh::~BamgMesh(){

	xfree((void**)&this->Vertices);
	xfree((void**)&this->Edges);
	xfree((void**)&this->Triangles);
	xfree((void**)&this->Quadrilaterals);
	xfree((void**)&this->VerticesOnGeometricVertex);
	xfree((void**)&this->VerticesOnGeometricEdge);
	xfree((void**)&this->EdgesOnGeometricEdge);
	xfree((void**)&this->SubDomains);
	xfree((void**)&this->SubDomainsFromGeom);
	xfree((void**)&this->hVertices);
	xfree((void**)&this->IssmEdges);
	xfree((void**)&this->IssmSegments);
	xfree((void**)&this->ElementConnectivity);
	xfree((void**)&this->NodalConnectivity);
	xfree((void**)&this->NodalElementConnectivity);
	xfree((void**)&this->CrackedVertices);
	xfree((void**)&this->CrackedEdges);

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgMesh::GetMatlabStructureFields{{{1*/
#ifdef _SERIAL_
void BamgMesh::GetMatlabStructureFields(mxArray* matlab_struct){

	int lines,cols;

	FetchData(&this->Triangles,                &this->TrianglesSize[0],                &this->TrianglesSize[1],                mxGetField(matlab_struct,0,"Triangles"));
	FetchData(&this->Vertices,                 &this->VerticesSize[0],                 &this->VerticesSize[1],                 mxGetField(matlab_struct,0,"Vertices"));
	FetchData(&this->Edges,                    &this->EdgesSize[0],                    &this->EdgesSize[1],                    mxGetField(matlab_struct,0,"Edges"));
	FetchData(&this->IssmSegments,             &this->IssmSegmentsSize[0],             &this->IssmSegmentsSize[1],             mxGetField(matlab_struct,0,"IssmSegments"));
	FetchData(&this->CrackedEdges,            &this->CrackedEdgesSize[0],              &this->CrackedEdgesSize[1],             mxGetField(matlab_struct,0,"CrackedEdges"));
	FetchData(&this->EdgesOnGeometricEdge,     &this->EdgesOnGeometricEdgeSize[0],     &this->EdgesOnGeometricEdgeSize[1],     mxGetField(matlab_struct,0,"EdgesOnGeometricEdge"));
	FetchData(&this->VerticesOnGeometricEdge,  &this->VerticesOnGeometricEdgeSize[0],  &this->VerticesOnGeometricEdgeSize[1],  mxGetField(matlab_struct,0,"VerticesOnGeometricEdge"));
	FetchData(&this->VerticesOnGeometricVertex,&this->VerticesOnGeometricVertexSize[0],&this->VerticesOnGeometricVertexSize[1],mxGetField(matlab_struct,0,"VerticesOnGeometricVertex"));
	FetchData(&this->hVertices,                &lines,                                 &cols,                                  mxGetField(matlab_struct,0,"hVertices"));
	if (this->hVertices && (cols!=1 || lines!=this->VerticesSize[0])){ISSMERROR("the size of 'hVertices' should be [%i %i]",this->VerticesSize[0],1);}

}
#endif
/*}}}*/
/*FUNCTION BamgMesh::SetMatlabStructureFields{{{1*/
#ifdef _SERIAL_
void BamgMesh::SetMatlabStructureFields(mxArray** matlab_struct){

	/*Intermediary*/
	int         i,i1,i2;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	mxArray*    output=NULL;
	int         numfields=16;
	const char* fnames[numfields];
	int         fsize[numfields][2];
	double**    fpointer[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	/*Build fnames and fsize names and sizes of each field*/
	i=-1;
	fnames[++i] = "Triangles";                fsize[i][0]=this->TrianglesSize[0];                 fsize[i][1]=this->TrianglesSize[1];                fpointer[i]=&this->Triangles;
	fnames[++i] = "Vertices";                 fsize[i][0]=this->VerticesSize[0];                  fsize[i][1]=this->VerticesSize[1];                 fpointer[i]=&this->Vertices;
	fnames[++i] = "Edges";                    fsize[i][0]=this->EdgesSize[0];                     fsize[i][1]=this->EdgesSize[1];                    fpointer[i]=&this->Edges;
	fnames[++i] = "IssmSegments";             fsize[i][0]=this->IssmSegmentsSize[0];              fsize[i][1]=this->IssmSegmentsSize[1];             fpointer[i]=&this->IssmSegments;
	fnames[++i] = "IssmEdges";                fsize[i][0]=this->IssmEdgesSize[0];                 fsize[i][1]=this->IssmEdgesSize[1];                fpointer[i]=&this->IssmEdges;
	fnames[++i] = "Quadrilaterals";           fsize[i][0]=this->QuadrilateralsSize[0];            fsize[i][1]=this->QuadrilateralsSize[1];           fpointer[i]=&this->Quadrilaterals;
	fnames[++i] = "VerticesOnGeometricVertex";fsize[i][0]=this->VerticesOnGeometricVertexSize[0]; fsize[i][1]=this->VerticesOnGeometricVertexSize[1];fpointer[i]=&this->VerticesOnGeometricVertex;
	fnames[++i] = "VerticesOnGeometricEdge";  fsize[i][0]=this->VerticesOnGeometricEdgeSize[0];   fsize[i][1]=this->VerticesOnGeometricEdgeSize[1];  fpointer[i]=&this->VerticesOnGeometricEdge;
	fnames[++i] = "EdgesOnGeometricEdge";     fsize[i][0]=this->EdgesOnGeometricEdgeSize[0];      fsize[i][1]=this->EdgesOnGeometricEdgeSize[1];     fpointer[i]=&this->EdgesOnGeometricEdge;
	fnames[++i] = "SubDomains";               fsize[i][0]=this->SubDomainsSize[0];                fsize[i][1]=this->SubDomainsSize[1];               fpointer[i]=&this->SubDomains;
	fnames[++i] = "SubDomainsFromGeom";       fsize[i][0]=this->SubDomainsFromGeomSize[0];        fsize[i][1]=this->SubDomainsFromGeomSize[1];       fpointer[i]=&this->SubDomainsFromGeom;
	fnames[++i] = "ElementConnectivity";      fsize[i][0]=this->ElementConnectivitySize[0];       fsize[i][1]=this->ElementConnectivitySize[1];      fpointer[i]=&this->ElementConnectivity;
	fnames[++i] = "NodalConnectivity";        fsize[i][0]=this->NodalConnectivitySize[0];         fsize[i][1]=this->NodalConnectivitySize[1];        fpointer[i]=&this->NodalConnectivity;
	fnames[++i] = "NodalElementConnectivity"; fsize[i][0]=this->NodalElementConnectivitySize[0];  fsize[i][1]=this->NodalElementConnectivitySize[1]; fpointer[i]=&this->NodalElementConnectivity;
	fnames[++i] = "CrackedVertices";          fsize[i][0]=this->CrackedVerticesSize[0];           fsize[i][1]=this->CrackedVerticesSize[1];          fpointer[i]=&this->CrackedVertices;
	fnames[++i] = "CrackedEdges";             fsize[i][0]=this->CrackedEdgesSize[0];              fsize[i][1]=this->CrackedEdgesSize[1];             fpointer[i]=&this->CrackedEdges;
	ISSMASSERT(i==numfields-1);

	/*Initialize Matlab structure*/
	output=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	/*Add every field tu structure*/
	for(i=0;i<numfields;i++){

		/*Copy field*/
		double*  fieldcopy=NULL;
		if (fsize[i][0]*fsize[i][1]){
			fieldcopy=(double*)xmalloc(fsize[i][0]*fsize[i][1]*sizeof(double));
			for(i1=0;i1<fsize[i][0];i1++){
				for(i2=0;i2<fsize[i][1];i2++){
					fieldcopy[fsize[i][1]*i1+i2]=*(*fpointer[i] + fsize[i][1]*i1+i2);
				}
			}
		}

		/*Set matlab field*/
		pfield=mxCreateDoubleMatrix(0,0,mxREAL);
		mxSetM(pfield,fsize[i][1]);
		mxSetN(pfield,fsize[i][0]);
		mxSetPr(pfield,fieldcopy);
		mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
		mxSetField(output,0,fnames[i],pfield2);
	}

	/*Assign output*/
	*matlab_struct=output;

}
#endif
/*}}}*/
