#include "stdio.h"
#include "../objects.h"
#include "../../io/io.h"

/*Constructors/Destructors*/
/*FUNCTION BamgGeom::BamgGeom(){{{1*/
BamgGeom::BamgGeom(){

	this->VerticesSize[0]=0,          this->VerticesSize[1]=0;          this->Vertices=NULL;
	this->EdgesSize[0]=0,             this->EdgesSize[1]=0;             this->Edges=NULL;
	this->hVertices=NULL;
	this->MetricVertices=NULL;
	this->TangentAtEdgesSize[0]=0,    this->TangentAtEdgesSize[1]=0;    this->TangentAtEdges=NULL;
	this->CornersSize[0]=0,           this->CornersSize[1]=0;           this->Corners=NULL;
	this->RequiredVerticesSize[0]=0,  this->RequiredVerticesSize[1]=0;  this->RequiredVertices=NULL;
	this->RequiredEdgesSize[0]=0,     this->RequiredEdgesSize[1]=0;     this->RequiredEdges=NULL;
	this->CrackedEdgesSize[0]=0,      this->CrackedEdgesSize[1]=0;      this->CrackedEdges=NULL;
	this->SubDomainsSize[0]=0,        this->SubDomainsSize[1]=0;        this->SubDomains=NULL;

}
/*}}}*/
/*FUNCTION BamgGeom::~BamgGeom(){{{1*/
BamgGeom::~BamgGeom(){

	xfree((void**)&this->Vertices);
	xfree((void**)&this->Edges);
	xfree((void**)&this->hVertices);
	xfree((void**)&this->MetricVertices);
	xfree((void**)&this->TangentAtEdges);
	xfree((void**)&this->Corners);
	xfree((void**)&this->RequiredVertices);
	xfree((void**)&this->RequiredEdges);
	xfree((void**)&this->CrackedEdges);
	xfree((void**)&this->SubDomains);

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgGeom::GetMatlabStructureFields{{{1*/
#ifdef _SERIAL_
void BamgGeom::GetMatlabStructureFields(mxArray* matlab_struct){

	int lines,cols;

	FetchData(&this->Vertices,        &this->VerticesSize[0],        &this->VerticesSize[1],        mxGetField(matlab_struct,0,"Vertices"));
	FetchData(&this->Edges,           &this->EdgesSize[0],           &this->EdgesSize[1],           mxGetField(matlab_struct,0,"Edges"));
	FetchData(&this->Corners,         &this->CornersSize[0],         &this->CornersSize[1],         mxGetField(matlab_struct,0,"Corners"));
	FetchData(&this->RequiredVertices,&this->RequiredVerticesSize[0],&this->RequiredVerticesSize[1],mxGetField(matlab_struct,0,"RequiredVertices"));
	FetchData(&this->RequiredEdges,   &this->RequiredEdgesSize[0],   &this->RequiredEdgesSize[1],   mxGetField(matlab_struct,0,"RequiredEdges"));
	FetchData(&this->CrackedEdges,    &this->CrackedEdgesSize[0],    &this->CrackedEdgesSize[1],    mxGetField(matlab_struct,0,"CrackedEdges"));
	FetchData(&this->SubDomains,      &this->SubDomainsSize[0],      &this->SubDomainsSize[1],      mxGetField(matlab_struct,0,"SubDomains"));
	FetchData(&this->hVertices,&lines,&cols,mxGetField(matlab_struct,0,"hVertices"));
	if (this->hVertices && (cols!=1 || lines!=this->VerticesSize[0])){ISSMERROR("the size of 'hVertices' should be [%i %i]",this->VerticesSize[0],1);}

}
#endif
/*}}}*/
/*FUNCTION BamgGeom::SetMatlabStructureFields{{{1*/
#ifdef _SERIAL_
void BamgGeom::SetMatlabStructureFields(mxArray** matlab_struct){

	/*Intermediary*/
	int         i,i1,i2;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	mxArray*    output=NULL;
	int         numfields=7;
	const char* fnames[numfields];
	int         fsize[numfields][2];
	double**    fpointer[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	/*Build fnames and fsize names and sizes of each field*/
	i=-1;
	fnames[++i] = "Vertices";        fsize[i][0]=this->VerticesSize[0];        fsize[i][1]=this->VerticesSize[1];        fpointer[i]=&this->Vertices;
	fnames[++i] = "Edges";           fsize[i][0]=this->EdgesSize[0];           fsize[i][1]=this->EdgesSize[1];           fpointer[i]=&this->Edges;
	fnames[++i] = "TangentAtEdges";  fsize[i][0]=this->TangentAtEdgesSize[0];  fsize[i][1]=this->TangentAtEdgesSize[1];  fpointer[i]=&this->TangentAtEdges;
	fnames[++i] = "RequiredVertices";fsize[i][0]=this->RequiredVerticesSize[0];fsize[i][1]=this->RequiredVerticesSize[1];fpointer[i]=&this->RequiredVertices;
	fnames[++i] = "RequiredEdges";   fsize[i][0]=this->RequiredEdgesSize[0];   fsize[i][1]=this->RequiredEdgesSize[1];   fpointer[i]=&this->RequiredEdges;
	fnames[++i] = "CrackedEdges";    fsize[i][0]=this->CrackedEdgesSize[0];    fsize[i][1]=this->CrackedEdgesSize[1];    fpointer[i]=&this->CrackedEdges;
	fnames[++i] = "SubDomains";      fsize[i][0]=this->SubDomainsSize[0];      fsize[i][1]=this->SubDomainsSize[1];      fpointer[i]=&this->SubDomains;
	ISSMASSERT(i==numfields-1);

	/*Initialize Matlab structure*/
	output=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	/*Add every field tu structure*/
	for(i=0;i<numfields;i++){

		/*Copy field*/
		double*  fieldcopy=NULL;
		if (fsize[i][0]*fsize[i][1]){
			fieldcopy=(double*)xmalloc(fsize[i][0]*fsize[i][1]*sizeof(double));
			for(i1=0;i1<fsize[i][0];i1++){
				for(i2=0;i2<fsize[i][1];i2++){
					fieldcopy[fsize[i][1]*i1+i2]=*(*fpointer[i] + fsize[i][1]*i1+i2);
				}
			}
		}

		/*Set matlab field*/
		pfield=mxCreateDoubleMatrix(0,0,mxREAL);
		mxSetM(pfield,fsize[i][1]);
		mxSetN(pfield,fsize[i][0]);
		mxSetPr(pfield,fieldcopy);
		mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
		mxSetField(output,0,fnames[i],pfield2);
	}

	/*Assign output*/
	*matlab_struct=output;

}
#endif
/*}}}*/
