/*!\file:  PenaltyConstraintsLocal.h
 * \brief local header files
 */ 

#ifndef _PENALTYCONSTRAINTSLOCAL_H
#define _PENALTYCONSTRAINTSLOCAL_H

#include "../../Container/Container.h"
#include "../../objects/objects.h"

/*melting: */
void  MeltingConstraints(Loads* loads, int* pconverged, int* pnum_unstable_constraints,int analysis_type);
int   MeltingIsPresent(Loads* loads,int analysis_type);

/*rifts module: */
int    RiftIsPresent(Loads* loads,int analysis_type);
void   RiftConstraints(int* pconverged, int* pnum_unstable_constraints,Loads* loads,int min_mechanical_constraints,int analysis_type);
void   RiftConstrain(int* pnum_unstable_constraints,Loads* loads,int analysis_type);
int    RiftIsFrozen(Loads* loads,int analysis_type);
void   RiftFreezeConstraints(Loads* loads,int analysis_type);

/*rifts, trial and errors: */
int    RiftIsPreStable(Loads* loads);
void   RiftSetPreStable(Loads* loads);
void   RiftPreConstrain(int* pnum_unstable_constraints,Loads* loads);
void   RiftMaxPenetrationInInputs(Loads* loads);
int    RiftPotentialUnstableConstraints(Loads* loads);
int    RiftIsMaterialStable(Loads* loads);

#endif  /* _PENALTYCONSTRAINTSX_H */

