#include "stdio.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../objects.h"

/*Constructors/Destructors*/
/*FUNCTION BamgOpts::BamgOpts() {{{1*/
BamgOpts::BamgOpts(){

	this->iso=0;
	this->maxnbv=0;
	this->MaxCornerAngle=0;
	this->Hessiantype=0;
	this->Metrictype=0;
	this->KeepVertices=0;
	this->Crack=0;
	this->maxsubdiv=0;
	this->power=0;
	this->anisomax=0;
	this->nbsmooth=0;
	this->nbjacobi=0;
	this->omega=0;
	this->hmin=0;
	this->hmax=0;
	this->hminVertices=NULL;
	this->hmaxVertices=NULL;
	this->gradation=0;
	this->cutoff=0;
	this->splitcorners=0;
	this->geometricalmetric=0;
	this->verbose=0;
	this->err=NULL;
	this->errg=0;
	this->coeff=0;
	this->metric=NULL;
	this->field=NULL;
	this->numfields=0;

}
/*}}}*/
/*FUNCTION BamgOpts::~BamgOpts() {{{1*/
BamgOpts::~BamgOpts(){

	xfree((void**)&this->hminVertices);
	xfree((void**)&this->hmaxVertices);
	xfree((void**)&this->err);
	xfree((void**)&this->metric);
	xfree((void**)&this->field);

}
/*}}}*/

/*Methods*/
/*FUNCTION BamgOpts::Check{{{1*/
void BamgOpts::Check(void){

	int i;

	if (this->coeff==0) ISSMERROR("'coeff' should be positive");
	if (this->maxsubdiv<=1) ISSMERROR("'maxsubdiv' should be >1");
	if (this->Crack!=0  && this->Crack!=1) ISSMERROR("'Crack' supported options are 0 and 1");
	if (this->Hessiantype!=0  && this->Hessiantype!=1) ISSMERROR("'Hessiantype' supported options are 0 and 1");
	if (this->Metrictype!=0   && this->Metrictype!=1 && this->Metrictype!=2) ISSMERROR("'Metrictype' supported options are 0, 1 and 2");
	if (this->KeepVertices!=0 && this->KeepVertices!=1) ISSMERROR("'KeepVertices' supported options are 0 and 1");
	if (this->errg<0) ISSMERROR("'errg' option should be >0");
	if (this->nbjacobi<=0) ISSMERROR("'nbjacobi' option should be >0");
	if (this->geometricalmetric!=0  && this->geometricalmetric!=1) ISSMERROR("'geometricalmetric' supported options are 0 and 1");
	if (this->nbsmooth<=0) ISSMERROR("'nbsmooth' option should be >0");
	if (this->maxnbv<3) ISSMERROR("'maxnbv' option should be >3");
	if (this->hmin<=0) ISSMERROR("'hmin' option should be >0");
	if (this->hmax<=0 || this->hmax<this->hmin) ISSMERROR("'hmax' option should be between 0 and hmin=%g",this->hmin);
	if (this->anisomax<1) ISSMERROR("'anisomax' option should be >=1");
	if (this->gradation<1) ISSMERROR("'gradation' option should be >=1");
	for (i=0;i<this->numfields;i++) {if (this->err[i]<=0) ISSMERROR("'err' option should be >0");};

}
/*}}}*/
