#ifndef _GEOMETRICALEDGE_H_
#define _GEOMETRICALEDGE_H_

#include "./include.h"

namespace bamg {

	//classes
	class GeometricalVertex;
	class Geometry;

	class GeometricalEdge {

		public:
			GeometricalVertex *v[2];
			long               ReferenceNumber;
			long               CurveNumber;
			R2                 tg[2];         // the 2 tangentes (tg[0] =0 => no continuity)
			GeometricalEdge   *Adj[2];
			int                DirAdj[2];
			int                type;

			//Operators
			GeometricalVertex       & operator[](int i){return *v[i];};
			const GeometricalVertex & operator[](int i) const { return *v[i];};
			GeometricalVertex       * operator()(int i){return v[i];};  

			//Methods
			R2     F(double theta) const ; // parametrization of the curve edge
			double R1tg(double theta,R2 &t) const ; // 1/radius of curvature + tangente
			int    Tg(int i) const;
			int    Cracked() const;
			int    TgA()     const;
			int    TgB()     const;
			int    Mark()    const;
			int    Required();
			void   SetCracked();
			void   SetTgA();
			void   SetTgB();
			void   SetMark();
			void   SetUnMark();
			void   SetRequired();
			void   Set(const GeometricalEdge & rec,const Geometry & Th ,Geometry & ThNew);
	};

}
#endif
